/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.ext.sapinst.swing.controls.logbrowser;

import com.sap.sdt.gui.ext.sapinst.images.ImageHolder;
import com.sap.sdt.gui.ext.sapinst.swing.controls.logbrowser.AutoScrollListener;
import com.sap.sdt.gui.ext.sapinst.swing.controls.logbrowser.ColoredTextControlLine;
import com.sap.sdt.gui.ext.sapinst.swing.controls.logbrowser.ColoredTextControlParser;
import com.sap.sdt.gui.ext.sapinst.swing.controls.logbrowser.CopyStatusListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollBar;

public class ColoredTextControl
extends JComponent
implements AdjustmentListener,
ClipboardOwner {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/ext/sapinst/swing/controls/logbrowser/ColoredTextControl.java#2 $";
    private Font stdFont;
    private FontMetrics fontMetrics;
    private int charWidth;
    private int lineHeight;
    private int iconHeight;
    private int iconWidth;
    private int marginLeft;
    private int marginRight;
    private int marginTop;
    private int marginBottom;
    private String iconSpace;
    private Color stdBGColor;
    private Color selectedBGColor;
    private Color selectedFontColor;
    private int blockSpace;
    private int stateOffset;
    private boolean autoScroll;
    private ArrayList showedMessages = new ArrayList();
    private ArrayList selectedMessages = new ArrayList();
    private int stateLastSelected;
    private ArrayList messages = new ArrayList();
    private AutoScrollListener autoScrollListener = null;
    private CopyStatusListener copyStatusListener = null;
    private Thread logPrinter = null;
    private JScrollBar scrollBar;

    public ColoredTextControl() {
        this.stdFont = new Font("Courier", 0, 12);
        this.stdBGColor = Color.white;
        this.selectedBGColor = Color.blue;
        this.selectedFontColor = Color.white;
        this.initControl();
    }

    public ColoredTextControl(Color bgColor, Color selectedBGColor, Color selectedFontColor) {
        this.stdFont = new Font("Courier", 0, 12);
        this.stdBGColor = bgColor;
        this.selectedBGColor = selectedBGColor;
        this.selectedFontColor = selectedFontColor;
        this.initControl();
    }

    private void initControl() {
        this.setLayout(new BorderLayout());
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                ColoredTextControl.this.onMouseEvent(e);
            }
        });
        this.autoScroll = true;
        this.stateOffset = 0;
        this.stateLastSelected = -1;
        this.iconHeight = 19;
        this.iconWidth = 21;
        this.iconSpace = "";
        this.fontMetrics = this.getFontMetrics(this.stdFont);
        this.lineHeight = this.fontMetrics.getHeight();
        this.charWidth = this.fontMetrics.charWidth('a');
        int tempIconSpace = 21 / this.fontMetrics.charWidth(' ') + 1;
        for (int i = 0; i < tempIconSpace; ++i) {
            this.iconSpace = this.iconSpace + " ";
        }
        this.scrollBar = new JScrollBar(1, 0, 1, 0, 1);
        this.scrollBar.setValue(0);
        this.scrollBar.setMinimum(0);
        this.scrollBar.setMaximum(this.messages.size() - 1);
        this.scrollBar.addAdjustmentListener(this);
        this.add((Component)this.scrollBar, "East");
        this.scrollBar.setVisible(true);
        this.marginLeft = 5;
        this.marginRight = 10;
        this.marginTop = this.lineHeight;
        this.marginBottom = 0;
        this.blockSpace = this.lineHeight;
    }

    public void paint(Graphics graphic) {
        super.paint(graphic);
        graphic.setColor(this.stdBGColor);
        graphic.fillRect(0, 0, this.getWidth() - this.scrollBar.getWidth(), this.getHeight());
        graphic.setFont(this.stdFont);
        this.showedMessages = new ArrayList();
        if (this.messages.size() > 0) {
            this.paintLines(graphic);
        }
        if (this.scrollBar.getValue() != this.stateOffset) {
            this.scrollBar.setValue(this.stateOffset);
        }
    }

    private void paintLines(Graphics graphic) {
        ColoredTextControlLine curMsg;
        int currentHeight = 0;
        boolean lastPixelSize = false;
        int curMsgID = this.stateOffset;
        int maxHeight = this.getHeight() - this.marginTop - this.marginBottom;
        int maxWidth = this.getWidth() - this.marginLeft - this.marginRight;
        int curHeight = 0;
        boolean testHeight = true;
        ShowedMessage tempMsg = null;
        if (this.autoScroll) {
            curMsgID = this.messages.size() - 1;
            while (curMsgID >= 0 && testHeight) {
                tempMsg = new ShowedMessage();
                curMsg = (ColoredTextControlLine)this.messages.get(curMsgID);
                if (!curMsg.isParsed) {
                    ColoredTextControlParser.parseLine(curMsg);
                }
                tempMsg.lines = this.splitLines(curMsg.text, maxWidth, this.charWidth, curMsg.icon);
                if (tempMsg.lines.size() * this.lineHeight + curHeight + this.blockSpace < maxHeight) {
                    tempMsg.msgID = curMsgID;
                    tempMsg.icon = curMsg.icon;
                    tempMsg.color = curMsg.color;
                    this.stateOffset = curMsgID--;
                    curHeight += tempMsg.lines.size() * this.lineHeight + this.blockSpace;
                    this.showedMessages.add(0, tempMsg);
                    continue;
                }
                testHeight = false;
            }
        } else {
            curMsgID = this.stateOffset;
            while (curMsgID < this.messages.size() && testHeight) {
                tempMsg = new ShowedMessage();
                curMsg = (ColoredTextControlLine)this.messages.get(curMsgID);
                if (!curMsg.isParsed) {
                    ColoredTextControlParser.parseLine(curMsg);
                }
                tempMsg.lines = this.splitLines(curMsg.text, maxWidth, this.charWidth, curMsg.icon);
                if (tempMsg.lines.size() * this.lineHeight + curHeight < maxHeight) {
                    tempMsg.msgID = curMsgID++;
                    tempMsg.icon = curMsg.icon;
                    tempMsg.color = curMsg.color;
                    curHeight += tempMsg.lines.size() * this.lineHeight;
                    this.showedMessages.add(tempMsg);
                    continue;
                }
                testHeight = false;
            }
            if (curMsgID < this.messages.size()) {
                curMsg = (ColoredTextControlLine)this.messages.get(curMsgID);
                if (!curMsg.isParsed) {
                    ColoredTextControlParser.parseLine(curMsg);
                }
                tempMsg.lines = this.splitLines(curMsg.text, maxWidth, this.charWidth, curMsg.icon);
                tempMsg.msgID = curMsgID++;
                tempMsg.icon = curMsg.icon;
                tempMsg.color = curMsg.color;
                curHeight += tempMsg.lines.size() * this.lineHeight;
                this.showedMessages.add(tempMsg);
            }
        }
        currentHeight = this.marginTop;
        for (int i = 0; i < this.showedMessages.size(); ++i) {
            int lineWidth;
            FontMetrics fontMetrics;
            int j;
            boolean selected = false;
            tempMsg = (ShowedMessage)this.showedMessages.get(i);
            int curLine = 0;
            tempMsg.yMin = currentHeight - this.lineHeight;
            graphic.setColor(tempMsg.color);
            for (j = 0; j < this.selectedMessages.size(); ++j) {
                if (tempMsg.msgID != ((SelectedMessage)this.selectedMessages.get((int)j)).msgID) continue;
                selected = true;
                break;
            }
            if (tempMsg.icon != null) {
                if (selected) {
                    fontMetrics = graphic.getFontMetrics();
                    lineWidth = fontMetrics.stringWidth((String)tempMsg.lines.get(curLine));
                    graphic.setColor(this.selectedBGColor);
                    graphic.fillRect(this.marginLeft + fontMetrics.stringWidth(this.iconSpace), currentHeight - this.lineHeight + 2, lineWidth -= fontMetrics.stringWidth(this.iconSpace), this.lineHeight);
                    graphic.setColor(this.selectedFontColor);
                }
                graphic.drawImage(tempMsg.icon.getImage(), this.marginLeft, currentHeight - this.lineHeight + 2, this);
                graphic.drawString((String)tempMsg.lines.get(curLine), this.marginLeft, currentHeight);
                currentHeight += this.lineHeight;
                ++curLine;
            }
            for (j = curLine; j < tempMsg.lines.size(); ++j) {
                if (selected) {
                    fontMetrics = graphic.getFontMetrics();
                    lineWidth = fontMetrics.stringWidth((String)tempMsg.lines.get(curLine));
                    graphic.setColor(this.selectedBGColor);
                    graphic.fillRect(this.marginLeft, currentHeight - this.lineHeight + 2, lineWidth, this.lineHeight);
                    graphic.setColor(this.selectedFontColor);
                }
                graphic.drawString((String)tempMsg.lines.get(j), this.marginLeft, currentHeight);
                currentHeight += this.lineHeight;
                ++curLine;
            }
            tempMsg.yMax = currentHeight - this.lineHeight;
            currentHeight += this.blockSpace;
        }
    }

    public ArrayList splitLines(String line, int canvasWidth, int charWidth, ImageIcon icon) {
        ArrayList<String> lines2Show = new ArrayList<String>();
        int maxCharCount = canvasWidth / charWidth - 1;
        int lineStart = 0;
        int curPos = 0;
        LinebreakPosition breakPos = null;
        if (icon != null) {
            line = this.iconSpace + line;
        }
        while (curPos < line.length()) {
            breakPos = new LinebreakPosition(curPos);
            while (!breakPos.executeBreak && curPos < lineStart + maxCharCount && curPos < line.length()) {
                if (!breakPos.breakFound) {
                    if (line.charAt(curPos) == ' ') {
                        breakPos.position = curPos;
                    }
                    if (line.charAt(curPos) == '\n') {
                        breakPos.position = curPos - 1;
                        breakPos.breakFound = true;
                    }
                } else if (line.charAt(curPos) != '\n' && line.charAt(curPos) != '\r' && line.charAt(curPos) != ' ') {
                    breakPos.executeBreak = true;
                    continue;
                }
                ++curPos;
            }
            if (breakPos.breakFound) {
                lines2Show.add(line.substring(lineStart, breakPos.position + 1));
                for (lineStart = curPos; lineStart < line.length() && (line.charAt(lineStart) == '\n' || line.charAt(lineStart) == '\r' || line.charAt(lineStart) == ' '); ++lineStart) {
                }
            } else if (curPos >= line.length()) {
                lines2Show.add(line.substring(lineStart));
            } else {
                if (breakPos.position < lineStart + maxCharCount / 2) {
                    breakPos.position = curPos - 1;
                    lines2Show.add(line.substring(lineStart, breakPos.position + 1));
                    lineStart = curPos;
                } else {
                    lines2Show.add(line.substring(lineStart, breakPos.position + 1));
                    lineStart = breakPos.position + 1;
                }
                while (lineStart < line.length() && (line.charAt(lineStart) == '\n' || line.charAt(lineStart) == '\r' || line.charAt(lineStart) == ' ')) {
                    ++lineStart;
                }
            }
            if (curPos >= lineStart) continue;
            curPos = lineStart;
        }
        return lines2Show;
    }

    public void appendLines(List appLines) {
        Object cur = null;
        Object newLine = null;
        for (int i = 0; i < appLines.size(); ++i) {
            cur = appLines.get(i);
            if (cur instanceof ColoredTextControlLine) {
                this.messages.add(cur);
                continue;
            }
            this.messages.add(ColoredTextControlParser.parseLine((String)cur));
        }
        this.scrollBar.setMinimum(0);
        this.scrollBar.setMaximum(this.messages.size() - 1);
        if (this.autoScroll) {
            this.scrollBar.setValue(this.messages.size());
            this.repaint();
        }
    }

    public void appendText(String text) {
        int min = 0;
        boolean max = false;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != '\n') continue;
            if (i + 1 < text.length() && text.charAt(i + 1) == '\r') {
                if (min < i - 1) {
                    this.messages.add(new ColoredTextControlLine(null, text.substring(min, i), Color.gray));
                } else {
                    this.messages.add(new ColoredTextControlLine(null, "", Color.gray));
                }
                min = i + 2;
                continue;
            }
            if (min < i - 1) {
                this.messages.add(new ColoredTextControlLine(null, text.substring(min, i), Color.gray));
            } else {
                this.messages.add(new ColoredTextControlLine(null, "", Color.gray));
            }
            min = i + 1;
        }
        if (min < text.length() - 1) {
            this.messages.add(new ColoredTextControlLine(null, text.substring(min, text.length() - 1), Color.gray));
        }
        this.scrollBar.setMinimum(0);
        this.scrollBar.setMaximum(this.messages.size() - 1);
        if (this.autoScroll) {
            this.scrollBar.setValue(this.messages.size());
            this.repaint();
        }
    }

    public void reset() {
        this.messages = new ArrayList();
        this.stateLastSelected = -1;
        this.selectedMessages = new ArrayList();
        this.showedMessages = new ArrayList();
        this.stateOffset = 0;
        this.scrollBar.setMinimum(0);
        this.scrollBar.setMaximum(0);
        this.scrollBar.setValue(0);
        this.setAutoScroll(true);
        this.repaint();
    }

    public void selectAll() {
        boolean messagesSelectedPrevious = false;
        boolean messagesSelectedAfter = false;
        if (this.selectedMessages.size() > 0) {
            messagesSelectedPrevious = true;
        }
        this.selectedMessages = new ArrayList();
        for (int i = 0; i < this.messages.size(); ++i) {
            this.selectedMessages.add(new SelectedMessage(i));
        }
        if (this.copyStatusListener != null) {
            if (this.selectedMessages.size() > 0) {
                messagesSelectedAfter = true;
            }
            if (messagesSelectedAfter != messagesSelectedPrevious) {
                this.copyStatusListener.copyStatusChanged(this, messagesSelectedAfter);
            }
        }
        this.repaint();
    }

    public String getText() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.messages.size(); ++i) {
            buffer.append(((ColoredTextControlLine)this.messages.get((int)i)).text);
            buffer.append('\n');
        }
        return buffer.toString();
    }

    public ArrayList getPrintableText(int paperSize, int charWidth) {
        ArrayList<String> printableLines = new ArrayList<String>();
        for (int i = 0; i < this.messages.size(); ++i) {
            boolean selected = false;
            for (int j = 0; j < this.selectedMessages.size(); ++j) {
                if (i != ((SelectedMessage)this.selectedMessages.get((int)j)).msgID) continue;
                selected = true;
                break;
            }
            if (!selected) continue;
            ColoredTextControlLine curLine = (ColoredTextControlLine)this.messages.get(i);
            printableLines.addAll(this.splitLines(curLine.text, paperSize, charWidth, null));
            if (this.blockSpace <= 0) continue;
            printableLines.add(" ");
        }
        return printableLines;
    }

    public int countSelectedMessages() {
        return this.selectedMessages.size();
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (this.autoScroll && e.getValue() < this.stateOffset) {
            this.autoScroll = false;
            if (this.autoScrollListener != null) {
                this.autoScrollListener.autoScrollChanged(this, false);
            }
        }
        this.stateOffset = e.getValue();
        this.repaint();
    }

    public void onMouseEvent(MouseEvent e) {
        int i;
        Object msg = null;
        ShowedMessage curMsg = null;
        SelectedMessage selMsg = null;
        int mousePosition = e.getY();
        int curID = -1;
        int lastID = -1;
        boolean messagesSelectedPrevious = false;
        boolean messagesSelectedAfter = false;
        if (this.selectedMessages.size() > 0) {
            messagesSelectedPrevious = true;
        }
        if (!e.isControlDown() && !e.isShiftDown()) {
            this.selectedMessages = new ArrayList();
            for (i = 0; i < this.showedMessages.size(); ++i) {
                curMsg = (ShowedMessage)this.showedMessages.get(i);
                if (mousePosition <= curMsg.yMin || mousePosition >= curMsg.yMax) continue;
                this.stateLastSelected = curMsg.msgID;
                this.selectedMessages.add(new SelectedMessage(curMsg.msgID));
            }
        }
        if (!e.isControlDown() && e.isShiftDown()) {
            lastID = this.stateLastSelected;
            for (i = 0; i < this.showedMessages.size(); ++i) {
                curMsg = (ShowedMessage)this.showedMessages.get(i);
                if (mousePosition <= curMsg.yMin || mousePosition >= curMsg.yMax) continue;
                curID = curMsg.msgID;
                break;
            }
            if (curID < lastID) {
                int temp = curID;
                curID = lastID;
                lastID = temp;
            }
            this.selectedMessages = new ArrayList();
            for (i = lastID; i <= curID; ++i) {
                this.selectedMessages.add(new SelectedMessage(i));
            }
        }
        if (e.isControlDown() && !e.isShiftDown()) {
            curID = -1;
            for (i = 0; i < this.showedMessages.size(); ++i) {
                curMsg = (ShowedMessage)this.showedMessages.get(i);
                if (mousePosition <= curMsg.yMin || mousePosition >= curMsg.yMax) continue;
                this.stateLastSelected = curMsg.msgID;
                curID = curMsg.msgID;
                break;
            }
            for (i = 0; i < this.selectedMessages.size(); ++i) {
                selMsg = (SelectedMessage)this.selectedMessages.get(i);
                if (curID != selMsg.msgID) continue;
                this.selectedMessages.remove(selMsg);
                this.stateLastSelected = -1;
                curID = -1;
                break;
            }
            if (curID >= 0) {
                this.selectedMessages.add(new SelectedMessage(curID));
            }
        }
        if (this.copyStatusListener != null) {
            if (this.selectedMessages.size() > 0) {
                messagesSelectedAfter = true;
            }
            if (messagesSelectedAfter != messagesSelectedPrevious) {
                this.copyStatusListener.copyStatusChanged(this, messagesSelectedAfter);
            }
        }
        this.repaint();
    }

    protected void processComponentKeyEvent(KeyEvent e) {
        if (e.getKeyCode() == 33) {
            this.setAutoScroll(false);
            if (this.stateOffset > 0) {
                --this.stateOffset;
                this.repaint();
            }
        }
        if (e.getKeyCode() == 34) {
            this.setAutoScroll(false);
            if (this.stateOffset < this.messages.size() - 1) {
                ++this.stateOffset;
                this.repaint();
            }
        }
        if (e.getKeyCode() == 38) {
            this.setAutoScroll(false);
            if (this.stateOffset > 0) {
                --this.stateOffset;
                this.repaint();
            }
        }
        if (e.getKeyCode() == 40) {
            this.setAutoScroll(false);
            if (this.stateOffset < this.messages.size() - 1) {
                ++this.stateOffset;
                this.repaint();
            }
        }
        if (e.getKeyCode() == 65 && e.isControlDown()) {
            this.selectAll();
            this.repaint();
        }
        super.processComponentEvent(e);
    }

    public void sendToClipBoard() {
        if (this.selectedMessages.size() > 0) {
            Clipboard clip = this.getToolkit().getSystemClipboard();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.selectedMessages.size(); ++i) {
                ColoredTextControlLine curMsg = (ColoredTextControlLine)this.messages.get(((SelectedMessage)this.selectedMessages.get((int)i)).msgID);
                stringBuffer.append(curMsg.text + '\n');
            }
            StringSelection cont = new StringSelection(stringBuffer.toString());
            clip.setContents(cont, this);
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public void registerAutoScrollListener(AutoScrollListener listener) {
        this.autoScrollListener = listener;
    }

    public void registerCopyStatusListener(CopyStatusListener listener) {
        this.copyStatusListener = listener;
    }

    public void setAutoScroll(boolean enabled) {
        if (this.autoScroll != enabled) {
            this.autoScroll = enabled;
            if (this.autoScrollListener != null) {
                this.autoScrollListener.autoScrollChanged(this, enabled);
            }
        }
    }

    public void setStdLinefeed() {
        this.blockSpace = this.lineHeight;
    }

    public void setLinefeed(int pixel) {
        this.blockSpace = pixel;
    }

    public void setLogfileType(String type) {
        if (type.equalsIgnoreCase("sapinstlog")) {
            this.setStdLinefeed();
        } else {
            this.setLinefeed(0);
        }
    }

    public void printSelected() {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        if (this.countSelectedMessages() < 1) {
            Object[] options = new Object[]{"Ok", "Cancel"};
            int returnValue = JOptionPane.showConfirmDialog(this, "Do you really want to print the entire document?\n\nThis may take a long time!", "No Messages selected.", 2, 2);
            if (returnValue != 0) {
                return;
            }
            this.selectAll();
            this.repaint();
        }
        if ((this.logPrinter == null || !this.logPrinter.isAlive()) && printJob.printDialog()) {
            this.logPrinter = new Thread(new LogPrinter(printJob, this));
            this.logPrinter.start();
        }
    }

    public static void main(String[] args) {
        JFrame bspFrame = new JFrame();
        ArrayList<Object> myLines = new ArrayList<Object>();
        ColoredTextControl myTextControl = new ColoredTextControl();
        ColoredTextControlLine myLine = new ColoredTextControlLine(ImageHolder.LOG_BROWSER_ERROR_ICON, "0123456789_0123456789_0123456789_0123456789_0123456789_0123456789_0123456789_0123456789_0123456789_0123456789_0123456789_0123456789_0123456789_0123456789_0123456789_0123456789_0123456789", Color.black);
        myLines.add(myLine);
        myLine = new ColoredTextControlLine(ImageHolder.LOG_BROWSER_INFO_ICON, "INFO 2003-04-11 12:14:31\n Installation start: Friday, 11 April 2003, 12:12:50; installation directory: /tmp/d040881; product to be installed: Dialog Instance", Color.black);
        myLines.add(myLine);
        myLine = new ColoredTextControlLine(ImageHolder.LOG_BROWSER_ERROR_ICON, "Hallo Test! Zeile 1 ... Da bin ich mal gespannt, wie des jetzt angezeigt wird...", Color.black);
        myLines.add(myLine);
        myLine = new ColoredTextControlLine(ImageHolder.LOG_BROWSER_ERROR_ICON, "Hallo Test! Zeile 1b... Da bin ich mal gespannt,           wie des jetzt angezeigt wird...", Color.black);
        myLines.add(myLine);
        myLine = new ColoredTextControlLine(ImageHolder.LOG_BROWSER_ERROR_ICON, "Hallo Test! Zeile 2", Color.black);
        myLines.add(myLine);
        myLines.add("TRACE test\noder nicht \n Hallo alles klar !!!!");
        myLines.add("Dies ist ein Text\nmit verschiedenen ZeilenumbrLchen...\n\n\r\nBin mal gespannt, ob des richtig dargestellt wird.\n\rEigentlich sollte er die Dinger finden...\n");
        String text = "Dies ist ein Text\nmit verschiedenen ZeilenumbrLchen...\n\n\r\nBin mal gespannt, ob des richtig dargestellt wird.\n\rEigentlich sollte er die Dinger finden...\n";
        myTextControl.appendText(text);
        text = "INFO 2003-04-11 12:14:31\n Installation start: Friday, 11 April 2003, 12:12:50; installation directory: /tmp/d040881; product to be installed: Dialog Instance";
        myTextControl.appendText(text);
        myTextControl.appendLines(myLines);
        bspFrame.getContentPane().add(myTextControl);
        bspFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                System.exit(0);
            }
        });
        bspFrame.setSize(400, 300);
        bspFrame.show();
    }

    class SelectedMessage {
        int msgID;

        SelectedMessage(int msgID) {
            this.msgID = msgID;
        }
    }

    class ShowedMessage {
        int yMax;
        int yMin;
        int msgID;
        ArrayList lines;
        ImageIcon icon;
        Color color;

        ShowedMessage(int min, int max, int messageID, ArrayList lines, ImageIcon icon, Color color) {
            this.yMax = max;
            this.yMin = min;
            this.msgID = messageID;
            this.lines = lines;
            this.icon = icon;
            this.color = color;
        }

        ShowedMessage() {
        }
    }

    class LogPrinter
    implements Printable,
    Runnable {
        PrinterJob printJob;
        ArrayList lines;
        ColoredTextControl textControl;

        LogPrinter(PrinterJob printJob, ColoredTextControl textControl) {
            this.printJob = printJob;
            printJob.setPrintable(this);
            this.textControl = textControl;
            this.printJob = printJob;
        }

        public void run() {
            try {
                this.printJob.print();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public int print(Graphics graphic, PageFormat pf, int pageIndex) throws PrinterException {
            int factor = 4;
            Graphics2D scaledGraphic = (Graphics2D)graphic;
            scaledGraphic.scale(1.0 / (double)factor, 1.0 / (double)factor);
            int pageWidth = (int)pf.getImageableWidth() * factor - 10;
            int pageHeight = (int)pf.getImageableHeight() * factor;
            scaledGraphic.setFont(new Font("Monospaced", 0, 8 * factor));
            FontMetrics fm = scaledGraphic.getFontMetrics();
            int maxCharWidth = fm.charWidth('m');
            int lineHeight = fm.getAscent() + fm.getDescent();
            int linesPerPage = pageHeight / lineHeight;
            int currentIndex = pageIndex * linesPerPage;
            int currentPosX = (int)pf.getImageableX() * factor + 5;
            int currentPosY = (int)pf.getImageableY() * factor + lineHeight;
            if (this.lines == null) {
                this.lines = this.textControl.getPrintableText(pageWidth, maxCharWidth);
            }
            if (currentIndex >= this.lines.size()) {
                return 1;
            }
            scaledGraphic.setColor(Color.black);
            while (currentPosY <= pageHeight && currentIndex < this.lines.size()) {
                graphic.drawString((String)this.lines.get(currentIndex), currentPosX, currentPosY);
                currentPosY += lineHeight;
                ++currentIndex;
            }
            return 0;
        }
    }

    class LinebreakPosition {
        int position;
        int skipChars;
        boolean executeBreak;
        boolean breakFound;

        LinebreakPosition() {
            this.position = 0;
            this.executeBreak = false;
            this.skipChars = 0;
        }

        LinebreakPosition(int position) {
            this.position = position;
            this.skipChars = 0;
            this.breakFound = false;
            this.executeBreak = false;
        }
    }
}

