/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.ext.sapinst.swing.controls;

import com.sap.sdt.engine.ext.sapinst.controls.SAPinstStepBrowserIF;
import com.sap.sdt.engine.ext.sapinst.controls.SAPinstStepBrowserNode;
import com.sap.sdt.gui.core.resources.ResourceConstants;
import com.sap.sdt.gui.core.swing.controls.GuiControl;
import com.sap.sdt.gui.core.swing.ui.GuiAction;
import com.sap.sdt.gui.core.swing.util.MenuCreator;
import com.sap.sdt.gui.ext.sapinst.images.ImageHolder;
import com.sap.sdt.gui.ext.sapinst.swing.controls.stepbrowser.StepBrowserStatusControl;
import com.sap.sdt.gui.ext.sapinst.swing.controls.stepbrowser.StepBrowserTreeControl;
import com.sap.sdt.gui.ext.sapinst.swing.controls.stepbrowser.StepBrowserTreeModel;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.SoftBevelBorder;

public class SAPinstStepBrowser
extends GuiControl
implements SAPinstStepBrowserIF,
ActionListener,
ResourceConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/ext/sapinst/swing/controls/SAPinstStepBrowser.java#2 $";
    private JMenuBar menubar;
    private JFrame owner;
    private JRadioButtonMenuItem filter_dlg = null;
    private JRadioButtonMenuItem filter_inst = null;
    private JRadioButtonMenuItem filter_all = null;
    private JRadioButtonMenuItem filter_tech = null;
    private JRadioButtonMenuItem filter_display = null;
    private boolean but_dlg = true;
    private JPanel rootPanel;
    private JPanel controlPanel = new JPanel(new BorderLayout());
    private JPanel status = new JPanel();
    private JSplitPane splitpane = new JSplitPane(0);
    private StepBrowserTreeControl treecontrol;
    private JScrollPane scrollpaneTree;
    private StepBrowserStatusControl statuscontrol;
    private JScrollPane scrollpaneStatus;
    private JPanel systemBar = new JPanel(new BorderLayout());
    private JLabel systemtext = new JLabel("   System");
    private boolean show_dlg = true;
    private int DividerLocation = 1;
    private double faktor = 0.75;

    public SAPinstStepBrowser() {
        super(new JPanel());
        this.rootPanel = (JPanel)this.peer;
        this.statuscontrol = new StepBrowserStatusControl();
        this.treecontrol = new StepBrowserTreeControl(this.statuscontrol);
        this.initGUI();
    }

    public boolean validate() {
        return true;
    }

    private void initGUI() {
        this.rootPanel.setLayout(new BorderLayout());
        this.rootPanel.add("North", this.controlPanel);
        this.rootPanel.add("Center", this.splitpane);
        this.rootPanel.add("South", this.systemBar);
        this.menubar = new JMenuBar();
        JMenu menuSystem = MenuCreator.createJMenu("SYSTEM");
        this.menubar.add(menuSystem);
        menuSystem.addSeparator();
        GuiAction submitAndExitAction = new GuiAction(this, "SUBMIT_AND_EXIT", null);
        MenuCreator.addSubmenuTo(menuSystem, submitAndExitAction, 0);
        JMenu menuTools = MenuCreator.createJMenu("TOOLS");
        this.menubar.add(menuTools);
        GuiAction findAction = new GuiAction(this, "FIND", ImageHolder.STEP_BROWSER_SEARCH_ICON);
        MenuCreator.addSubmenuTo(menuTools, findAction, 0);
        menuTools.addSeparator();
        GuiAction collapseAllAction = new GuiAction(this, "COLLAPSE_ALL", ImageHolder.STEP_BROWSER_COLLAPSE_ICON);
        MenuCreator.addSubmenuTo(menuTools, collapseAllAction, 0);
        GuiAction expandAllAction = new GuiAction(this, "EXPAND_ALL", ImageHolder.STEP_BROWSER_EXPAND_ALL_ICON);
        MenuCreator.addSubmenuTo(menuTools, expandAllAction, 0);
        GuiAction expandErrorsAction = new GuiAction(this, "EXPAND_ERRORS", ImageHolder.STEP_BROWSER_EXPAND_ICON);
        MenuCreator.addSubmenuTo(menuTools, expandErrorsAction, 0);
        menuTools.addSeparator();
        GuiAction repeatAllAction = new GuiAction(this, "REPEAT_ALL", ImageHolder.STEP_BROWSER_REPEAT_ICON);
        MenuCreator.addSubmenuTo(menuTools, repeatAllAction, 0);
        GuiAction skipAllAction = new GuiAction(this, "SKIP_ALL", ImageHolder.STEP_BROWSER_SKIP_ICON);
        MenuCreator.addSubmenuTo(menuTools, skipAllAction, 0);
        GuiAction resetAllAction = new GuiAction(this, "RESET_ALL", ImageHolder.STEP_BROWSER_RESET_ICON);
        MenuCreator.addSubmenuTo(menuTools, resetAllAction, 0);
        JMenu menuFilter = MenuCreator.createJMenu("FILTER");
        this.menubar.add(menuFilter);
        JMenu menuStepFilter = MenuCreator.createJMenu("STEP_FILTER");
        menuFilter.add(menuStepFilter);
        GuiAction dialogsFilterAction = new GuiAction(this, "DIALOGS_STEPS_FILTER", ImageHolder.STEP_BROWSER_DLG_ICON);
        this.filter_dlg = (JRadioButtonMenuItem)MenuCreator.addSubmenuTo(menuStepFilter, dialogsFilterAction, 1);
        GuiAction installationsFilterAction = new GuiAction(this, "INSTALLATIONS_STEPS_FILTER", ImageHolder.STEP_BROWSER_INST_ICON);
        this.filter_inst = (JRadioButtonMenuItem)MenuCreator.addSubmenuTo(menuStepFilter, installationsFilterAction, 1);
        GuiAction allFilterAction = new GuiAction(this, "ALL_STEPS_FILTER", ImageHolder.STEP_BROWSER_ALL_ICON);
        this.filter_all = (JRadioButtonMenuItem)MenuCreator.addSubmenuTo(menuStepFilter, allFilterAction, 1);
        this.filter_dlg.setSelected(false);
        this.filter_inst.setSelected(false);
        this.filter_all.setSelected(true);
        JMenu menuComponentFilter = MenuCreator.createJMenu("COMPONENT_FILTER");
        menuFilter.add(menuComponentFilter);
        GuiAction display_nameFilterAction = new GuiAction(this, "DISPLAY_NAME_FILTER", null);
        this.filter_display = (JRadioButtonMenuItem)MenuCreator.addSubmenuTo(menuComponentFilter, display_nameFilterAction, 1);
        GuiAction tech_nameFilterAction = new GuiAction(this, "TECH_NAME_FILTER", null);
        this.filter_tech = (JRadioButtonMenuItem)MenuCreator.addSubmenuTo(menuComponentFilter, tech_nameFilterAction, 1);
        this.filter_display.setSelected(true);
        this.filter_tech.setSelected(false);
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.setBorder(new EtchedBorder());
        toolbar.add(collapseAllAction);
        toolbar.add(expandAllAction);
        toolbar.add(expandErrorsAction);
        toolbar.addSeparator();
        toolbar.addSeparator();
        toolbar.add(findAction);
        GuiAction back_action = new GuiAction(this, "BACK", ImageHolder.STEP_BROWSER_BACK_ICON);
        GuiAction forward_action = new GuiAction(this, "FORWARD", ImageHolder.STEP_BROWSER_FORWARD_ICON);
        toolbar.add(back_action);
        toolbar.add(forward_action);
        this.treecontrol.init_searchButtons(back_action, forward_action);
        toolbar.addSeparator();
        toolbar.addSeparator();
        toolbar.add(repeatAllAction);
        toolbar.add(skipAllAction);
        toolbar.add(resetAllAction);
        toolbar.addSeparator();
        this.scrollpaneTree = new JScrollPane(this.treecontrol);
        this.scrollpaneStatus = new JScrollPane(this.statuscontrol);
        this.controlPanel.add("South", toolbar);
        this.splitpane.setBorder(new EmptyBorder(2, 0, 2, 0));
        this.splitpane.setOneTouchExpandable(true);
        this.splitpane.setContinuousLayout(true);
        this.splitpane.setTopComponent(this.scrollpaneTree);
        this.splitpane.setBottomComponent(this.scrollpaneStatus);
        this.splitpane.setDividerSize(3);
        this.systemBar.setBorder(new BevelBorder(1));
        this.systemBar.add("Center", this.systemtext);
        this.systemtext.setBorder(new SoftBevelBorder(1));
        this.set_DividerLocation();
        toolbar.requestFocus();
    }

    private void set_DividerLocation() {
        this.DividerLocation = (int)((double)this.splitpane.getHeight() * this.faktor);
        this.splitpane.setDividerLocation(200);
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("REPEAT_ALL")) {
            this.treecontrol.repeat_all_steps();
        } else if (cmd.equals("SKIP_ALL")) {
            this.treecontrol.skip_all_steps();
        } else if (cmd.equals("RESET_ALL")) {
            this.treecontrol.reset_all_steps();
        } else if (cmd.equals("FIND")) {
            this.treecontrol.search(JOptionPane.showInputDialog(this.owner, "Find what: ", "Find !", 3));
        } else if (cmd.equals("COLLAPSE_ALL")) {
            this.treecontrol.collapseAll();
        } else if (cmd.equals("EXPAND_ERRORS")) {
            this.treecontrol.expandERRORNodes();
        } else if (cmd.equals("EXPAND_ALL")) {
            this.treecontrol.expandAll();
        } else if (!cmd.equals("SUBMIT_AND_EXIT")) {
            if (cmd.equals("TECH_NAME_FILTER")) {
                this.filter_tech.setSelected(true);
                this.filter_display.setSelected(false);
                this.treecontrol.show_componetTechname();
            } else if (cmd.equals("DISPLAY_NAME_FILTER")) {
                this.filter_tech.setSelected(false);
                this.filter_display.setSelected(true);
                this.treecontrol.show_componetDisplayname();
            } else if (cmd.equals("DIALOGS_STEPS_FILTER")) {
                this.but_dlg = false;
                this.filter_dlg.setSelected(true);
                this.filter_inst.setSelected(false);
                this.filter_all.setSelected(false);
                this.treecontrol.show_dlgSteps();
                this.treecontrol.requestFocus();
            } else if (cmd.equals("INSTALLATIONS_STEPS_FILTER")) {
                this.but_dlg = true;
                this.filter_dlg.setSelected(false);
                this.filter_inst.setSelected(true);
                this.filter_all.setSelected(false);
                this.treecontrol.show_instSteps();
                this.treecontrol.requestFocus();
            } else if (cmd.equals("ALL_STEPS_FILTER")) {
                this.but_dlg = true;
                this.filter_dlg.setSelected(false);
                this.filter_inst.setSelected(false);
                this.filter_all.setSelected(true);
                this.treecontrol.show_allSteps();
                this.treecontrol.requestFocus();
            } else if (cmd.equals("BACK")) {
                this.treecontrol.previous_Result();
            } else if (cmd.equals("FORWARD")) {
                this.treecontrol.next_Result();
            }
        }
    }

    public SAPinstStepBrowserNode getData() {
        return ((StepBrowserTreeModel)this.treecontrol.getModel()).getData();
    }

    public void setData(SAPinstStepBrowserNode root) {
        this.treecontrol.setTreeData(root);
    }

    public void setEnabled(boolean isEnabled) {
    }

    public void setOwner(JFrame owner) {
        this.owner = owner;
        owner.setTitle("StepBrowser");
        owner.setJMenuBar(this.menubar);
        owner.getContentPane().add(this.rootPanel);
        owner.setSize(200, 300);
    }

    public JFrame getOwner() {
        return this.owner;
    }

    public static void test() {
        SAPinstStepBrowser browser = new SAPinstStepBrowser();
        JFrame f = new JFrame();
        browser.setOwner(f);
        SAPinstStepBrowserNode root = new SAPinstStepBrowserNode();
        root.setName("Odd");
        SAPinstStepBrowserNode node1 = new SAPinstStepBrowserNode();
        node1.setName("Tech1");
        node1.setType(1);
        root.addChild(node1);
        SAPinstStepBrowserNode node2 = new SAPinstStepBrowserNode();
        node2.setType(2);
        node2.setName("Step1");
        node1.addChild(node2);
        SAPinstStepBrowserNode node3 = new SAPinstStepBrowserNode();
        node3.setName("display2");
        node3.setType(1);
        SAPinstStepBrowserNode node4 = new SAPinstStepBrowserNode();
        node4.setType(2);
        node4.setName("Step3");
        node3.addChild(node4);
        SAPinstStepBrowserNode node5 = new SAPinstStepBrowserNode();
        node5.setType(3);
        node5.setName("Step4");
        node3.addChild(node5);
        root.addChild(node3);
        SAPinstStepBrowserNode node6 = new SAPinstStepBrowserNode();
        node6.setName("display3");
        node6.setType(1);
        root.addChild(node6);
        SAPinstStepBrowserNode node7 = new SAPinstStepBrowserNode();
        node7.setType(2);
        node7.setName("Step5");
        node6.addChild(node7);
        SAPinstStepBrowserNode node8 = new SAPinstStepBrowserNode();
        node8.setType(3);
        node8.setName("Step6");
        node6.addChild(node8);
        SAPinstStepBrowserNode node9 = new SAPinstStepBrowserNode();
        node9.setName("display4");
        node9.setType(1);
        SAPinstStepBrowserNode node10 = new SAPinstStepBrowserNode();
        node10.setType(2);
        node10.setName("Step8");
        node9.addChild(node10);
        SAPinstStepBrowserNode node11 = new SAPinstStepBrowserNode();
        node11.setType(3);
        node11.setName("Step7");
        node9.addChild(node11);
        node6.addChild(node9);
        browser.setData(root);
        f.setVisible(true);
    }
}

