/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.ext.sapinst.swing.controls;

import com.sap.sdt.engine.ext.sapinst.controls.SAPinstProgressPanelIF;
import com.sap.sdt.gui.core.settings.GuiSettings;
import com.sap.sdt.gui.core.swing.controls.GuiComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;

public class SAPinstProgressPanel
extends GuiComponent
implements SAPinstProgressPanelIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/ext/sapinst/swing/controls/SAPinstProgressPanel.java#2 $";
    private final JPanel panel;
    private JList lsComponents;
    private JProgressBar pbTotal;
    private static JFrame frameMain;

    public SAPinstProgressPanel() {
        super(new JPanel());
        this.panel = (JPanel)this.peer;
        this.createDefaultLayout();
    }

    public void createDefaultLayout() {
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.panel.putClientProperty("scrollable_form", Boolean.FALSE);
        this.panel.putClientProperty("resizing", Boolean.TRUE);
        this.lsComponents = new JList(){

            public void addMouseListener(MouseListener l) {
            }

            public void addMouseMotionListener(MouseMotionListener l) {
            }

            protected void processKeyEvent(KeyEvent e) {
            }
        };
        this.lsComponents.setFocusable(false);
        this.lsComponents.setFont(GuiSettings.getInstance().getFont("label"));
        this.lsComponents.setSelectionMode(0);
        this.lsComponents.setForeground(Color.black);
        JScrollPane sc = new JScrollPane(this.lsComponents);
        sc.setAlignmentX(0.5f);
        this.pbTotal = new JProgressBar();
        this.pbTotal.setAlignmentX(0.5f);
        this.pbTotal.setFont(GuiSettings.getInstance().getFont("label"));
        JPanel pn1 = new JPanel();
        this.panel.add(sc);
        this.panel.add(Box.createVerticalStrut(5));
        this.panel.add(this.pbTotal);
    }

    public void setEnabled(boolean isEnabled) {
    }

    public boolean validate() {
        return true;
    }

    public void setProgressList(String[] items) {
        this.lsComponents.setListData(items);
        this.lsComponents.clearSelection();
        this.pbTotal.setMaximum(items.length + 1);
        this.pbTotal.setMinimum(0);
    }

    public void setProgressListIndex(int index) {
        if (index == -1) {
            this.lsComponents.clearSelection();
            this.pbTotal.setValue(0);
            return;
        }
        this.lsComponents.setSelectedIndex(index);
        this.lsComponents.ensureIndexIsVisible(index);
        this.pbTotal.setValue(index + 1);
    }

    public void done() {
        this.pbTotal.setValue(this.pbTotal.getMaximum());
        this.setProgressListIndex(this.lsComponents.getModel().getSize() - 1);
    }

    private static SAPinstProgressPanel createTestPanel() {
        SAPinstProgressPanel progress = new SAPinstProgressPanel();
        Vector<String> data = new Vector<String>();
        data.add("Line1");
        data.add("Line2");
        data.add("Line3 is a very long line to test the horizontal scrollbar");
        data.add("Line4");
        data.add("Line5");
        data.add("Line6");
        data.add("Line7");
        data.add("Line8");
        data.add("Line9");
        progress.setProgressList(data.toArray(new String[data.size()]));
        return progress;
    }

    public static void test() {
        JFrame f;
        frameMain = f = new JFrame("SAPinstProgressPanel Test");
        SAPinstProgressPanel progress = SAPinstProgressPanel.createTestPanel();
        f.setContentPane(progress.getPeer());
        f.pack();
        f.setLocation(200, 100);
        f.show();
        progress.setProgressListIndex(7);
    }

    public static void main(String[] args) {
        GuiSettings.getInstance();
        SAPinstProgressPanel.test();
        frameMain.setDefaultCloseOperation(3);
    }

    public static void print(Component comp) {
        if (comp == null) {
            System.out.println("component = null");
            return;
        }
        System.out.println("class name=" + comp.getClass().getName());
        System.out.println("min size : width=" + comp.getMinimumSize().width + "   height=" + comp.getMinimumSize().height);
        System.out.println("pref size: width=" + comp.getPreferredSize().width + "   height=" + comp.getPreferredSize().height);
        System.out.println("max size : width=" + comp.getMaximumSize().width + "   height=" + comp.getMaximumSize().height);
        System.out.println("real size : width=" + comp.getSize().width + "   height=" + comp.getSize().height);
    }
}

