/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.ext.sapinst.swing.controls;

import com.sap.sdt.engine.core.controls.SDTActionIF;
import com.sap.sdt.engine.core.controls.SDTActionListenerIF;
import com.sap.sdt.engine.core.event.SDTActionEvent;
import com.sap.sdt.engine.ext.sapinst.controls.SAPinstLogBrowserConstants;
import com.sap.sdt.engine.ext.sapinst.controls.SAPinstLogBrowserIF;
import com.sap.sdt.gui.core.resources.ResourceConstants;
import com.sap.sdt.gui.core.swing.controls.GuiControl;
import com.sap.sdt.gui.core.swing.ui.GuiAction;
import com.sap.sdt.gui.core.swing.util.MenuCreator;
import com.sap.sdt.gui.ext.sapinst.images.ImageHolder;
import com.sap.sdt.gui.ext.sapinst.swing.controls.logbrowser.AutoScrollListener;
import com.sap.sdt.gui.ext.sapinst.swing.controls.logbrowser.ColoredTextControl;
import com.sap.sdt.gui.ext.sapinst.swing.controls.logbrowser.CopyStatusListener;
import com.sap.sdt.gui.ext.sapinst.swing.controls.logbrowser.IconComboBox;
import com.sap.sdt.gui.ext.sapinst.swing.controls.logbrowser.IconComboBoxElement;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ToolTipManager;
import javax.swing.border.EtchedBorder;

public class SAPinstLogBrowser
extends GuiControl
implements AutoScrollListener,
CopyStatusListener,
ResourceConstants,
ActionListener,
SAPinstLogBrowserIF,
SAPinstLogBrowserConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/ext/sapinst/swing/controls/SAPinstLogBrowser.java#2 $";
    private IconComboBox jComboBoxFilterSettings = new IconComboBox();
    private IconComboBoxElement filterDescError;
    private IconComboBoxElement filterDescPhase;
    private IconComboBoxElement filterDescWarning;
    private IconComboBoxElement filterDescInfo;
    private IconComboBoxElement filterDescTrace;
    private IconComboBoxElement filterDescFlowTrace;
    private JRadioButtonMenuItem viewError_rb;
    private JRadioButtonMenuItem viewPhase_rb;
    private JRadioButtonMenuItem viewWarning_rb;
    private JRadioButtonMenuItem viewInfo_rb;
    private JRadioButtonMenuItem viewTrace_rb;
    private JRadioButtonMenuItem viewFlowTrace_rb;
    private JMenuBar menuBar;
    private JPanel panel;
    private JToggleButton autoScrollButton;
    private GuiAction copyAction;
    private GuiAction autoScrollAction;
    private ColoredTextControl logEditor = new ColoredTextControl();
    private String severity = "INFO";
    private SDTActionListenerIF listener = null;
    private String currentFile = null;

    public SAPinstLogBrowser() {
        super(new JPanel());
        this.panel = (JPanel)this.peer;
        this.panel.setLayout(new BorderLayout());
        this.menuBar = new JMenuBar();
        this.menuBar.setBorderPainted(false);
        JMenu menuFile = MenuCreator.createJMenu("FILE");
        this.menuBar.add(menuFile);
        GuiAction openLogFileAction = new GuiAction(this, "OPEN_LOG", ImageHolder.LOG_BROWSER_OPEN_ICON);
        MenuCreator.addSubmenuTo(menuFile, openLogFileAction, 0);
        menuFile.add(new JSeparator());
        GuiAction rereadLogFileAction = new GuiAction(this, "REREAD_LOG", null);
        MenuCreator.addSubmenuTo(menuFile, rereadLogFileAction, 0);
        rereadLogFileAction.setEnabled(false);
        menuFile.add(new JSeparator());
        GuiAction printAction = new GuiAction(this, "PRINT", ImageHolder.LOG_BROWSER_PRINT_ICON);
        MenuCreator.addSubmenuTo(menuFile, printAction, 0);
        menuFile.add(new JSeparator());
        GuiAction closeAction = new GuiAction(this, "CLOSE", null);
        MenuCreator.addSubmenuTo(menuFile, closeAction, 0);
        JMenu menuEdit = MenuCreator.createJMenu("EDIT");
        this.menuBar.add(menuEdit);
        this.copyAction = new GuiAction(this, "COPY", ImageHolder.LOG_BROWSER_COPY_ICON);
        MenuCreator.addSubmenuTo(menuEdit, this.copyAction, 0);
        GuiAction selectAllAction = new GuiAction(this, "SELECT_ALL", null);
        MenuCreator.addSubmenuTo(menuEdit, selectAllAction, 0);
        JMenu menuView = MenuCreator.createJMenu("VIEW");
        this.menuBar.add(menuView);
        ButtonGroup group = new ButtonGroup();
        GuiAction viewErrorsAction = new GuiAction(this, "ERRORS_ONLY", ImageHolder.LOG_BROWSER_ERROR_ICON);
        this.viewError_rb = (JRadioButtonMenuItem)MenuCreator.addSubmenuTo(menuView, viewErrorsAction, 1);
        group.add(this.viewError_rb);
        GuiAction viewWarningsAction = new GuiAction(this, "WARNINGS", ImageHolder.LOG_BROWSER_WARNING_ICON);
        this.viewWarning_rb = (JRadioButtonMenuItem)MenuCreator.addSubmenuTo(menuView, viewWarningsAction, 1);
        group.add(this.viewWarning_rb);
        GuiAction viewPhaseInfoAction = new GuiAction(this, "PHASE", ImageHolder.LOG_BROWSER_PHASE_ICON);
        this.viewPhase_rb = (JRadioButtonMenuItem)MenuCreator.addSubmenuTo(menuView, viewPhaseInfoAction, 1);
        group.add(this.viewPhase_rb);
        GuiAction viewInfoAction = new GuiAction(this, "INFO", ImageHolder.LOG_BROWSER_INFO_ICON);
        this.viewInfo_rb = (JRadioButtonMenuItem)MenuCreator.addSubmenuTo(menuView, viewInfoAction, 1);
        group.add(this.viewInfo_rb);
        menuView.add(new JSeparator());
        GuiAction viewTraceAction = new GuiAction(this, "TRACE", ImageHolder.LOG_BROWSER_TRACE_ICON);
        this.viewTrace_rb = (JRadioButtonMenuItem)MenuCreator.addSubmenuTo(menuView, viewTraceAction, 1);
        group.add(this.viewTrace_rb);
        GuiAction viewFlowTraceAction = new GuiAction(this, "FLOW_TRACE", ImageHolder.LOG_BROWSER_TRACE_ICON);
        this.viewFlowTrace_rb = (JRadioButtonMenuItem)MenuCreator.addSubmenuTo(menuView, viewFlowTraceAction, 1);
        group.add(this.viewFlowTrace_rb);
        this.panel.add("Center", this.logEditor);
        this.logEditor.registerAutoScrollListener(this);
        this.filterDescError = new IconComboBoxElement(ImageHolder.LOG_BROWSER_ERROR_ICON, (String)viewErrorsAction.getValue("Name"), viewErrorsAction);
        this.filterDescWarning = new IconComboBoxElement(ImageHolder.LOG_BROWSER_WARNING_ICON, (String)viewWarningsAction.getValue("Name"), viewWarningsAction);
        this.filterDescPhase = new IconComboBoxElement(ImageHolder.LOG_BROWSER_PHASE_ICON, (String)viewPhaseInfoAction.getValue("Name"), viewPhaseInfoAction);
        this.filterDescInfo = new IconComboBoxElement(ImageHolder.LOG_BROWSER_INFO_ICON, (String)viewInfoAction.getValue("Name"), viewInfoAction);
        this.filterDescTrace = new IconComboBoxElement(ImageHolder.LOG_BROWSER_TRACE_ICON, (String)viewTraceAction.getValue("Name"), viewTraceAction);
        this.filterDescFlowTrace = new IconComboBoxElement(ImageHolder.LOG_BROWSER_TRACE_ICON, (String)viewFlowTraceAction.getValue("Name"), viewFlowTraceAction);
        this.jComboBoxFilterSettings.addItem(this.filterDescError);
        this.jComboBoxFilterSettings.addItem(this.filterDescWarning);
        this.jComboBoxFilterSettings.addItem(this.filterDescPhase);
        this.jComboBoxFilterSettings.addItem(this.filterDescInfo);
        this.jComboBoxFilterSettings.addItem(this.filterDescTrace);
        this.jComboBoxFilterSettings.addItem(this.filterDescFlowTrace);
        this.jComboBoxFilterSettings.setSelectedItem(this.filterDescInfo);
        this.jComboBoxFilterSettings.addActionListener(this);
        this.jComboBoxFilterSettings.setToolTipText("Choose threshold to filter messages");
        ToolTipManager.sharedInstance().setEnabled(true);
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.setBorder(new EtchedBorder());
        toolbar.add(openLogFileAction);
        toolbar.add(printAction);
        toolbar.addSeparator();
        toolbar.add(this.copyAction);
        this.autoScrollAction = new GuiAction(this, "AUTO_SCROLL", ImageHolder.LOG_BROWSER_SCROLL_ICON);
        this.autoScrollButton = new JToggleButton(this.autoScrollAction);
        toolbar.add(this.autoScrollButton);
        toolbar.addSeparator();
        toolbar.add(this.jComboBoxFilterSettings);
        this.jComboBoxFilterSettings.setMaximumSize(this.jComboBoxFilterSettings.getPreferredSize());
        toolbar.add(Box.createHorizontalGlue());
        toolbar.setFocusTraversalKeys(2, Collections.EMPTY_SET);
        toolbar.setFocusTraversalKeys(3, Collections.EMPTY_SET);
        this.panel.add("North", toolbar);
        ImageIcon icon = ImageHolder.LOG_BROWSER_ICON;
        this.viewInfo_rb.setSelected(true);
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = null;
        Object source = e.getSource();
        if (source == this.jComboBoxFilterSettings) {
            IconComboBoxElement cb = (IconComboBoxElement)this.jComboBoxFilterSettings.getSelectedItem();
            cmd = ((GuiAction)cb.getAction()).getCommand();
        } else {
            cmd = e.getActionCommand();
        }
        if (cmd.equals("OPEN_LOG")) {
            this.openAction();
        } else if (cmd.equals("REREAD_LOG")) {
            this.refreshAction();
        } else if (cmd.equals("PRINT")) {
            this.printAction();
        } else {
            if (cmd.equals("CLOSE")) {
                this.closeAction(e);
                return;
            }
            if (cmd.equals("COPY")) {
                this.copyAction(e);
            } else if (cmd.equals("SELECT_ALL")) {
                this.selectAllAction(e);
            } else if (cmd.equals("AUTO_SCROLL")) {
                this.autoscrollAction(e);
            } else if (cmd.equals("ERRORS_ONLY") && !this.severity.equals("ERROR")) {
                this.logEditor.reset();
                this.severity = "ERROR";
                this.jComboBoxFilterSettings.setSelectedItem(this.filterDescError);
                this.viewError_rb.setSelected(true);
            } else if (cmd.equals("PHASE") && !this.severity.equals("PHASE")) {
                this.logEditor.reset();
                this.severity = "PHASE";
                this.jComboBoxFilterSettings.setSelectedItem(this.filterDescPhase);
                this.viewPhase_rb.setSelected(true);
            } else if (cmd.equals("INFO") && !this.severity.equals("INFO")) {
                this.logEditor.reset();
                this.severity = "INFO";
                this.jComboBoxFilterSettings.setSelectedItem(this.filterDescInfo);
                this.viewInfo_rb.setSelected(true);
            } else if (cmd.equals("WARNINGS") && !this.severity.equals("WARNING")) {
                this.logEditor.reset();
                this.severity = "WARNING";
                this.jComboBoxFilterSettings.setSelectedItem(this.filterDescWarning);
                this.viewWarning_rb.setSelected(true);
            } else if (cmd.equals("TRACE") && !this.severity.equals("TRACE")) {
                this.logEditor.reset();
                this.severity = "TRACE";
                this.jComboBoxFilterSettings.setSelectedItem(this.filterDescTrace);
                this.viewTrace_rb.setSelected(true);
            } else if (cmd.equals("FLOW_TRACE") && !this.severity.equals("FLOW TRACE")) {
                this.logEditor.reset();
                this.severity = "FLOW TRACE";
                this.jComboBoxFilterSettings.setSelectedItem(this.filterDescFlowTrace);
                this.viewFlowTrace_rb.setSelected(true);
            }
        }
        this.refreshAction();
    }

    public void copyStatusChanged(ColoredTextControl obj, boolean enabled) {
        this.copyAction.setEnabled(enabled);
    }

    public boolean validate() {
        return true;
    }

    public void clear() {
        this.logEditor.reset();
    }

    public void addText(String text) {
        this.logEditor.appendText(text);
    }

    public String getSeverity() {
        return this.severity;
    }

    public void setInitialSeverity(String severity) {
        int index = -1;
        if (severity.equalsIgnoreCase("error")) {
            index = 0;
        } else if (severity.equalsIgnoreCase("warning")) {
            index = 1;
        } else if (severity.equalsIgnoreCase("phase")) {
            index = 2;
        } else if (severity.equalsIgnoreCase("info")) {
            index = 3;
        } else if (severity.equalsIgnoreCase("trace")) {
            index = 4;
        } else if (severity.equalsIgnoreCase("flow trace")) {
            index = 5;
        } else {
            return;
        }
        this.jComboBoxFilterSettings.removeActionListener(this);
        this.jComboBoxFilterSettings.setSelectedIndex(index);
        this.jComboBoxFilterSettings.addActionListener(this);
        this.severity = severity.toUpperCase();
    }

    public void setListener(SDTActionListenerIF listener) {
        this.listener = listener;
    }

    public void setCurrentFile(String currentFile) {
        this.currentFile = currentFile;
        this.logEditor.setLogfileType(currentFile.startsWith("sapinst") ? "sapinstlog" : "generic");
    }

    public void addLines(List lines) {
        this.logEditor.appendLines(lines);
    }

    public void autoScrollChanged(ColoredTextControl obj, boolean enabled) {
        if (this.autoScrollAction != null) {
            this.autoScrollAction.setEnabled(true);
        }
        if (this.autoScrollButton.isSelected() != enabled) {
            this.autoScrollButton.setSelected(enabled);
        }
    }

    public void setEnabled(boolean isEnabled) {
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    public SDTActionIF getCloseAction() {
        return new CloseAction();
    }

    private void openAction() {
        this.remoteAction("Request");
    }

    private void refreshAction() {
        this.remoteAction("Refresh");
    }

    private void closeAction(ActionEvent event) {
        this.remoteAction("Close");
    }

    private void remoteAction(String action) {
        this.listener.actionPerformed(new SDTActionEvent(this, action));
    }

    private void copyAction(ActionEvent event) {
        this.logEditor.sendToClipBoard();
    }

    private void selectAllAction(ActionEvent event) {
        this.logEditor.selectAll();
    }

    private void autoscrollAction(ActionEvent event) {
        this.autoScrollAction.setEnabled(true);
        this.logEditor.setAutoScroll(this.autoScrollButton.isSelected());
    }

    private void printAction() {
        this.logEditor.printSelected();
    }

    private class CloseAction
    implements SDTActionIF {
        private CloseAction() {
        }

        public void perform() {
            SAPinstLogBrowser.this.closeAction(null);
        }
    }
}

