/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.ext.sapinst.swing.controls;

import com.sap.sdt.engine.ext.sapinst.controls.SAPinstCatalogIF;
import com.sap.sdt.engine.ext.sapinst.controls.SAPinstNodeIF;
import com.sap.sdt.gui.core.settings.GuiSettings;
import com.sap.sdt.gui.core.swing.controls.GuiComponent;
import com.sap.sdt.gui.core.swing.controls.GuiScrollableStyledText;
import com.sap.sdt.gui.core.swing.controls.GuiStyledText;
import com.sap.sdt.gui.ext.sapinst.images.ImageHolder;
import com.sap.sdt.gui.ext.sapinst.swing.controls.SAPinstNode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SAPinstCatalog
extends GuiComponent
implements SAPinstCatalogIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/ext/sapinst/swing/controls/SAPinstCatalog.java#2 $";
    private static final String DESC_TEXT = "Select the service to install.";
    private GuiStyledText description;
    private JScrollPane productPane;
    private JTree products;
    private SAPinstNode rootNode;
    private GuiScrollableStyledText userInfo;
    private final int totalWidth = 705;
    private final int defaultDividerLocation = 400;
    private final int minProductPaneWidth = 200;
    private final int minUserInfoWidth = 200;
    private JSplitPane spProductInfo;
    private final JPanel panel = (JPanel)this.peer;
    static /* synthetic */ Class class$java$awt$Graphics;
    static /* synthetic */ Class class$com$sap$sdt$gui$ext$sapinst$swing$controls$SAPinstCatalog;

    public SAPinstCatalog() {
        super(new JPanel());
    }

    public void setEnabled(boolean isEnabled) {
        this.products.setEnabled(isEnabled);
    }

    public boolean validate() {
        boolean isValid = false;
        SAPinstNode node = (SAPinstNode)this.products.getLastSelectedPathComponent();
        if (node != null && node.isLeaf()) {
            isValid = true;
        }
        return isValid;
    }

    public void setRootNode(SAPinstNodeIF rootNode) {
        this.rootNode = (SAPinstNode)rootNode;
        this.createDefaultLayout();
    }

    public String getSelectedID() {
        SAPinstNode node = (SAPinstNode)this.products.getLastSelectedPathComponent();
        return node.getID();
    }

    private void createDefaultLayout() {
        this.panel.setLayout(new BorderLayout(0, 10));
        this.panel.putClientProperty("scrollable_form", Boolean.FALSE);
        this.createDescPane();
        this.createProductPane();
        this.createInfoPane();
        this.createSplitPane();
        this.adjustDivider();
    }

    private void createDescPane() {
        this.description = new GuiStyledText();
        this.description.setText(DESC_TEXT);
        this.panel.add((Component)this.description.getPeer(), "North");
    }

    private void createProductPane() {
        this.products = new JTree(this.rootNode);
        this.products.setRootVisible(true);
        this.products.getSelectionModel().setSelectionMode(1);
        this.products.setFont(GuiSettings.getInstance().getFont("catalog.label"));
        this.products.setShowsRootHandles(false);
        CatalogTreeCellRenderer renderer = new CatalogTreeCellRenderer();
        renderer.setRootIcon(ImageHolder.ROOT);
        renderer.setClosedIcon(ImageHolder.DIR_CLOSE);
        renderer.setOpenIcon(ImageHolder.DIR_OPEN);
        renderer.setLeafIcon(ImageHolder.LEAF);
        this.products.setCellRenderer(renderer);
        this.expandTree();
        this.products.setSelectionPath(new TreePath(this.rootNode.getPath()));
        this.products.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                SAPinstNode node = (SAPinstNode)SAPinstCatalog.this.products.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                SAPinstCatalog.this.setInfo(node.getUserInfo());
                SAPinstCatalog.this.updateNextButton();
            }
        });
        this.products.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() >= 2 && evt.getButton() == 1) {
                    SAPinstCatalog.this.clickNextButton();
                }
            }
        });
        this.productPane = new JScrollPane(this.products);
        this.productPane.setHorizontalScrollBarPolicy(30);
        this.productPane.setVerticalScrollBarPolicy(20);
    }

    private void updateNextButton() {
        JButton bn = (JButton)((JComponent)this.panel.getParent()).getClientProperty("next_button_key");
        if (bn != null) {
            boolean valid = this.validate();
            bn.setEnabled(valid);
        }
    }

    private void clickNextButton() {
        JButton bn = (JButton)((JComponent)this.panel.getParent()).getClientProperty("next_button_key");
        if (bn != null) {
            bn.doClick();
        }
    }

    private void createInfoPane() {
        this.userInfo = new GuiScrollableStyledText();
    }

    private void createSplitPane() {
        this.spProductInfo = new JSplitPane(1, true, this.productPane, this.userInfo.getPeer());
        this.spProductInfo.setOneTouchExpandable(false);
        this.panel.add((Component)this.spProductInfo, "Center");
        this.productPane.setMinimumSize(new Dimension(200, 0));
        this.userInfo.getPeer().setMinimumSize(new Dimension(200, 0));
    }

    private void adjustDivider() {
        String displayName = this.rootNode.getDisplayName();
        if (displayName != null) {
            int width = SwingUtilities.computeStringWidth(this.products.getFontMetrics(this.products.getFont()), this.rootNode.getDisplayName()) + 30;
            int dividerLocation = Math.max(width, 400);
            dividerLocation = Math.min(dividerLocation, 505);
            this.spProductInfo.setDividerLocation(dividerLocation);
        }
    }

    private void setInfo(String info) {
        this.userInfo.setText(info);
    }

    private void expandTree() {
        this.products.expandPath(new TreePath(this.rootNode));
        int childNumber = this.rootNode.getChildCount();
        if (childNumber == 1) {
            TreeNode node = this.rootNode.getChildAt(0);
            boolean onlyServices = true;
            int nodeChildNumber = node.getChildCount();
            for (int i = 0; i < nodeChildNumber; ++i) {
                if (node.getChildAt(0).isLeaf()) continue;
                onlyServices = false;
            }
            if (onlyServices) {
                this.products.expandPath(new TreePath(new Object[]{this.rootNode, this.rootNode.getChildAt(0)}));
            }
        }
    }

    private static class CatalogTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private boolean drawsFocusBorderAroundIcon;
        private final boolean frogLnF;
        private Method drawFocusRectM;
        private Icon rootIcon;
        private Icon disabledRootIcon;
        private Icon disabledCloseIcon;
        private Icon disabledOpenIcon;
        private Icon disabledLeafIcon;
        static final /* synthetic */ boolean $assertionsDisabled;

        public CatalogTreeCellRenderer() {
            block3: {
                this.drawFocusRectM = null;
                Object value = UIManager.get("Tree.drawsFocusBorderAroundIcon");
                this.drawsFocusBorderAroundIcon = value != null && (Boolean)value != false;
                this.frogLnF = GuiSettings.isFrogLookAndFeel();
                if (this.frogLnF) {
                    try {
                        Class<?> cls = Class.forName("com.sap.plaf.frog.FrogBorders$FocusBorder");
                        this.drawFocusRectM = cls.getMethod("drawFocusRect", class$java$awt$Graphics == null ? (class$java$awt$Graphics = SAPinstCatalog.class$("java.awt.Graphics")) : class$java$awt$Graphics, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if ($assertionsDisabled) break block3;
                        throw new AssertionError();
                    }
                }
            }
        }

        public void setRootIcon(Icon newIcon) {
            this.rootIcon = newIcon;
            this.disabledRootIcon = this.getDisabledIcon(newIcon);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object treeNode, boolean isSelected, boolean isExpanded, boolean isLeaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, treeNode, isSelected, isExpanded, isLeaf, row, hasFocus);
            if (((DefaultMutableTreeNode)treeNode).isRoot()) {
                if (!this.isEnabled()) {
                    this.setDisabledIcon(this.disabledRootIcon);
                } else {
                    this.setIcon(this.rootIcon);
                }
            } else if (!this.isEnabled()) {
                if (isLeaf) {
                    this.setDisabledIcon(this.getDisabledLeafIcon());
                } else if (isExpanded) {
                    this.setDisabledIcon(this.getDisabledOpenIcon());
                } else {
                    this.setDisabledIcon(this.getDisabledClosedIcon());
                }
            }
            return this;
        }

        private Icon getDisabledClosedIcon() {
            if (this.disabledCloseIcon == null) {
                this.disabledCloseIcon = this.getDisabledIcon(this.getClosedIcon());
            }
            return this.disabledCloseIcon;
        }

        private Icon getDisabledLeafIcon() {
            if (this.disabledLeafIcon == null) {
                this.disabledLeafIcon = this.getDisabledIcon(this.getLeafIcon());
            }
            return this.disabledLeafIcon;
        }

        private Icon getDisabledOpenIcon() {
            if (this.disabledOpenIcon == null) {
                this.disabledOpenIcon = this.getDisabledIcon(this.getOpenIcon());
            }
            return this.disabledOpenIcon;
        }

        private ImageIcon getDisabledIcon(Icon newIcon) {
            Image disableImage = GrayFilter.createDisabledImage(((ImageIcon)newIcon).getImage());
            ImageIcon disabledIcon = new ImageIcon(disableImage);
            return disabledIcon;
        }

        public void paint(Graphics g) {
            if (!this.frogLnF) {
                super.paint(g);
            } else {
                boolean hasFocusBackup = this.hasFocus;
                this.hasFocus = false;
                super.paint(g);
                this.hasFocus = hasFocusBackup;
                int imageOffset = -1;
                if (this.hasFocus) {
                    Color bColor;
                    block10: {
                        if (this.drawsFocusBorderAroundIcon) {
                            imageOffset = 0;
                        } else if (imageOffset == -1) {
                            imageOffset = this.getLabelStart();
                        }
                        Color bsColor = this.getBorderSelectionColor();
                        if (bsColor != null) {
                            g.setColor(bsColor);
                            try {
                                this.drawFocusRectM.invoke(null, g, new Integer(imageOffset), new Integer(1), new Integer(this.getWidth() - imageOffset), new Integer(this.getHeight() - 1));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                if ($assertionsDisabled) break block10;
                                throw new AssertionError();
                            }
                        }
                    }
                    if ((bColor = this.getBackgroundNonSelectionColor()) == null) {
                        bColor = this.getBackground();
                    }
                    g.setColor(bColor);
                    g.fillRect(imageOffset, 0, this.getWidth() - 1 - imageOffset, 1);
                }
            }
        }

        private int getLabelStart() {
            Icon currentI = this.getIcon();
            if (currentI != null && this.getText() != null) {
                return currentI.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
            }
            return 0;
        }

        static {
            $assertionsDisabled = !(class$com$sap$sdt$gui$ext$sapinst$swing$controls$SAPinstCatalog == null ? (class$com$sap$sdt$gui$ext$sapinst$swing$controls$SAPinstCatalog = SAPinstCatalog.class$("com.sap.sdt.gui.ext.sapinst.swing.controls.SAPinstCatalog")) : class$com$sap$sdt$gui$ext$sapinst$swing$controls$SAPinstCatalog).desiredAssertionStatus();
        }
    }
}

