/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.ext.navigator.swing.controls.tree;

import com.sap.sdt.gui.ext.navigator.swing.controls.tree.AbstractNode;
import com.sap.sdt.gui.ext.navigator.swing.controls.tree.RootNode;
import com.sap.sdt.gui.ext.navigator.swing.controls.tree.ServerNode;
import com.sap.sdt.gui.ext.navigator.swing.controls.tree.ServerPopupMenu;
import com.sap.sdt.gui.ext.navigator.swing.controls.tree.ToolInstanceNode;
import com.sap.sdt.gui.ext.navigator.swing.controls.tree.ToolInstancePopupMenu;
import com.sap.sdt.gui.ext.navigator.swing.controls.tree.ToolNode;
import com.sap.sdt.gui.ext.navigator.swing.controls.tree.ToolPopupMenu;
import com.sap.sdt.gui.ext.navigator.swing.controls.tree.TreeCellRenderer;
import com.sap.sdt.gui.ext.navigator.swing.controls.tree.TreeConstants;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class Tree
extends JTree
implements TreeConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/ext/navigator/swing/controls/tree/Tree.java#2 $";
    private RootNode root;
    private DefaultTreeModel model;
    private JPopupMenu serverMenu = null;
    private JPopupMenu toolMenu = null;
    private JPopupMenu toolInstanceMenu = null;

    public Tree(int mode) {
        this.setCellRenderer(new TreeCellRenderer());
        this.getSelectionModel().setSelectionMode(1);
        this.root = new RootNode();
        this.model = new DefaultTreeModel(this.root);
        this.setModel(this.model);
        this.setShowsRootHandles(true);
        this.setEditable(false);
        this.setRootVisible(false);
        this.serverMenu = new ServerPopupMenu("Foo", this, mode);
        this.toolMenu = new ToolPopupMenu("Bar", this, mode);
        this.toolInstanceMenu = new ToolInstancePopupMenu("", this, mode);
    }

    public void addServerNode(ServerNode server) {
        this.model.insertNodeInto(server, this.root, this.root.getChildCount());
        this.model.setRoot(this.root);
    }

    public void addToolNode(ServerNode server, ToolNode tool) {
        this.model.insertNodeInto(tool, server, server.getChildCount());
        this.model.setRoot(this.root);
        this.expandRow(0);
    }

    public void addToolInstanceNode(ToolInstanceNode instance, ToolNode tool) {
        this.model.insertNodeInto(instance, tool, tool.getChildCount());
        this.model.setRoot(this.root);
        this.expandRow(0);
        this.expandRow(1);
    }

    public void showPopupMenu(MouseEvent e) {
        TreePath tP = this.getSelectionPath();
        AbstractNode node = (AbstractNode)tP.getLastPathComponent();
        switch (node.getType()) {
            case 1: {
                this.serverMenu.show(this, e.getX(), e.getY());
                break;
            }
            case 2: {
                this.toolMenu.show(this, e.getX(), e.getY());
                break;
            }
            case 3: {
                this.toolInstanceMenu.show(this, e.getX(), e.getY());
                break;
            }
        }
    }

    public void showPopupMenu() {
        TreePath tP = this.getSelectionPath();
        if (tP == null) {
            return;
        }
        AbstractNode node = (AbstractNode)tP.getLastPathComponent();
        if (node == null) {
            return;
        }
        Rectangle bounds = this.getPathBounds(tP);
        int x = bounds.x;
        int y = bounds.y;
        switch (node.getType()) {
            case 1: {
                this.serverMenu.show(this, x, y);
                break;
            }
            case 2: {
                this.toolMenu.show(this, x, y);
                break;
            }
            case 3: {
                this.toolInstanceMenu.show(this, x, y);
                break;
            }
        }
    }

    public JPopupMenu getServerMenu() {
        return this.serverMenu;
    }

    public JPopupMenu getToolInstanceMenu() {
        return this.toolInstanceMenu;
    }

    public JPopupMenu getToolMenu() {
        return this.toolMenu;
    }

    public void setServerMenu(JPopupMenu menu) {
        this.serverMenu = menu;
    }

    public void setToolInstanceMenu(JPopupMenu menu) {
        this.toolInstanceMenu = menu;
    }

    public void setToolMenu(JPopupMenu menu) {
        this.toolMenu = menu;
    }

    public JFrame getParentFrame(Container comp) {
        if (comp.getParent() == null) {
            return null;
        }
        if (comp.getParent() instanceof JFrame) {
            return (JFrame)comp.getParent();
        }
        return this.getParentFrame(comp.getParent());
    }
}

