/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.ext.navigator.swing.controls.tree;

import com.sap.sdt.engine.core.admin.SDTGuiAdminIF;
import com.sap.sdt.engine.core.admin.ServerID;
import com.sap.sdt.engine.core.communication.Configuration;
import com.sap.sdt.engine.core.services.ServiceKey;
import com.sap.sdt.engine.core.services.tool.ToolInfo;
import com.sap.sdt.engine.ext.navigator.NavigatorServiceIF;
import com.sap.sdt.gui.core.swing.ui.GuiStartToolDialog;
import com.sap.sdt.gui.ext.navigator.swing.controls.tree.ToolNode;
import com.sap.sdt.gui.ext.navigator.swing.controls.tree.Tree;
import com.sap.sdt.gui.ext.navigator.swing.controls.tree.TreeConstants;
import com.sap.sdt.gui.ext.navigator.swing.controls.tree.TreeMapper;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class ToolPopupMenu
extends JPopupMenu
implements ActionListener,
TreeConstants {
    private static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/ext/navigator/swing/controls/tree/ToolPopupMenu.java#2 $";
    private Tree tree = null;
    private GuiStartToolDialog startDialog = null;

    public ToolPopupMenu(String label, Tree tree, int mode) {
        super(label);
        this.tree = tree;
        switch (mode) {
            case 0: {
                this.addItem("Start New Instance", "CMD_START_TOOL");
                break;
            }
            case 1: {
                this.addItem("Disconnect All", "CMD_DISCONNECT_TOOL");
                break;
            }
        }
        this.addSeparator();
        this.addItem("Info", "CMD_SHOW_TOOL");
    }

    public void actionPerformed(ActionEvent action) {
        switch (TreeMapper.translateAction(action.getActionCommand())) {
            case 3: {
                this.showToolInfo();
                break;
            }
            case 0: {
                this.startTool();
                break;
            }
        }
    }

    private void addItem(String label, String cmd) {
        JMenuItem item = new JMenuItem(label);
        item.addActionListener(this);
        item.setActionCommand(cmd);
        this.add(item);
    }

    private void startTool() {
        if (this.startDialog == null) {
            this.startDialog = new GuiStartToolDialog(this.tree.getParentFrame(this.tree.getParent()));
        }
        int port = -1;
        if (!this.startDialog.showDialog()) {
            return;
        }
        port = this.startDialog.getPort();
        ToolNode sN = (ToolNode)this.tree.getSelectionPath().getLastPathComponent();
        ToolInfo tool = new ToolInfo(sN.getAdapter(), port, null);
        ServerID serverID = sN.getServerID();
        SDTGuiAdminIF gA = (SDTGuiAdminIF)Configuration.getClientAdmin();
        ServiceKey key = new ServiceKey(serverID, "ToolService", NavigatorServiceIF.class);
        NavigatorServiceIF tS = (NavigatorServiceIF)gA.getService(key);
        tS.startTool(tool);
    }

    private void showToolInfo() {
    }
}

