/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.ext.navigator.swing.controls.tree;

import com.sap.sdt.engine.core.admin.ClientID;
import com.sap.sdt.engine.core.admin.SDTGuiAdminIF;
import com.sap.sdt.engine.core.admin.ServerID;
import com.sap.sdt.engine.core.communication.Configuration;
import com.sap.sdt.engine.core.services.ServiceKey;
import com.sap.sdt.engine.core.services.tool.ToolID;
import com.sap.sdt.engine.ext.navigator.NavigatorServiceIF;
import com.sap.sdt.gui.core.swing.ui.GuiConnectInstanceDialog;
import com.sap.sdt.gui.ext.navigator.swing.controls.tree.ToolInstanceNode;
import com.sap.sdt.gui.ext.navigator.swing.controls.tree.Tree;
import com.sap.sdt.gui.ext.navigator.swing.controls.tree.TreeConstants;
import com.sap.sdt.gui.ext.navigator.swing.controls.tree.TreeMapper;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class ToolInstancePopupMenu
extends JPopupMenu
implements ActionListener,
TreeConstants {
    private static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/ext/navigator/swing/controls/tree/ToolInstancePopupMenu.java#2 $";
    private Tree tree = null;
    private GuiConnectInstanceDialog connectDialog = null;

    public ToolInstancePopupMenu(String label, Tree tree, int mode) {
        super(label);
        this.tree = tree;
        switch (mode) {
            case 0: {
                this.addItem("Connect", "CMD_CONNECT_TOOL");
                break;
            }
            case 1: {
                this.addItem("Disconnect", "CMD_DISCONNECT_TOOL");
                break;
            }
        }
        this.addSeparator();
        this.addItem("Info", "CMD_SHOW_TOOL");
    }

    public void actionPerformed(ActionEvent action) {
        switch (TreeMapper.translateAction(action.getActionCommand())) {
            case 1: {
                this.connectGui();
                break;
            }
            case 2: {
                this.disconnectTool();
                break;
            }
        }
    }

    private void addItem(String label, String cmd) {
        JMenuItem item = new JMenuItem(label);
        item.addActionListener(this);
        item.setActionCommand(cmd);
        this.add(item);
    }

    private void connectGui() {
        String[] roles = new String[]{"Administrator"};
        if (this.connectDialog == null) {
            this.connectDialog = new GuiConnectInstanceDialog(this.tree.getParentFrame(this.tree.getParent()));
        }
        this.connectDialog.setRoles(roles);
        String role = null;
        if (!this.connectDialog.showDialog()) {
            return;
        }
        role = this.connectDialog.getRole();
        SDTGuiAdminIF gA = (SDTGuiAdminIF)Configuration.getClientAdmin();
        ToolInstanceNode tN = (ToolInstanceNode)this.tree.getSelectionPath().getLastPathComponent();
        ToolID toolID = tN.getToolID();
        ServerID serverID = tN.getServerID();
        ClientID clientID = gA.getID();
        ServiceKey key = new ServiceKey(serverID, "ToolService", NavigatorServiceIF.class);
        NavigatorServiceIF tS = (NavigatorServiceIF)gA.getService(key);
        tS.connectGui(clientID, toolID, role);
    }

    private void disconnectTool() {
        ToolInstanceNode tN = (ToolInstanceNode)this.tree.getSelectionPath().getLastPathComponent();
        SDTGuiAdminIF gA = (SDTGuiAdminIF)Configuration.getClientAdmin();
        ToolID toolID = tN.getToolID();
        ServerID serverID = tN.getServerID();
        ClientID clientID = gA.getID();
        ServiceKey key = new ServiceKey(serverID, "ToolService", NavigatorServiceIF.class);
        NavigatorServiceIF tS = (NavigatorServiceIF)gA.getService(key);
        tS.disconnectGui(clientID, toolID);
    }

    private void showToolInfo() {
    }

    private void clearAllConnection() {
    }
}

