/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.ext.navigator.swing.controls;

import com.sap.sdt.engine.core.admin.ServerID;
import com.sap.sdt.engine.core.controls.SDTViewIF;
import com.sap.sdt.engine.core.services.tool.ToolAdapterInfo;
import com.sap.sdt.engine.core.services.tool.ToolID;
import com.sap.sdt.engine.core.services.tool.ToolInfo;
import com.sap.sdt.engine.ext.navigator.controls.SDTConnectionsViewIF;
import com.sap.sdt.engine.ext.navigator.controls.SDTNavigationViewIF;
import com.sap.sdt.engine.ext.navigator.controls.SDTNavigatorPerspectiveIF;
import com.sap.sdt.engine.ext.navigator.controls.SDTToolViewIF;
import com.sap.sdt.gui.core.resources.ResourceConstants;
import com.sap.sdt.gui.core.resources.ResourceManager;
import com.sap.sdt.gui.core.swing.controls.GuiPerspective;
import com.sap.sdt.gui.core.swing.controls.GuiView;
import com.sap.sdt.gui.core.swing.ui.decorator.TitleViewDecorator;
import com.sap.sdt.gui.ext.navigator.swing.controls.GuiConnectionsView;
import com.sap.sdt.gui.ext.navigator.swing.controls.GuiNavigatorView;
import com.sap.sdt.gui.ext.navigator.swing.controls.elements.ServerElement;
import com.sap.sdt.gui.ext.navigator.swing.controls.elements.ToolElement;
import com.sap.sdt.gui.ext.navigator.swing.controls.tree.RootNode;
import com.sap.sdt.gui.ext.navigator.swing.controls.tree.ServerNode;
import com.sap.sdt.gui.ext.navigator.swing.controls.tree.ToolInstanceNode;
import com.sap.sdt.gui.ext.navigator.swing.controls.tree.ToolNode;
import com.sap.sdt.gui.ext.navigator.swing.controls.tree.Tree;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.tree.DefaultTreeModel;

public class GuiToolPerspective
extends GuiPerspective
implements SDTNavigatorPerspectiveIF,
ResourceConstants,
FocusListener {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/ext/navigator/swing/controls/GuiToolPerspective.java#2 $";
    protected GuiView navigationView;
    protected GuiView toolView;
    protected GuiView connectionView;
    private JSplitPane splitPane;
    private JSplitPane navigatorSplit;

    public GuiToolPerspective() {
        this.initGui();
    }

    public void addServer(ServerID server, String host, int port) {
        ServerElement sE = new ServerElement(host, Integer.toString(port));
        ((GuiNavigatorView)this.navigationView).getTree().addServerNode(new ServerNode(sE, server));
    }

    public void addAdapterType(ServerID server, ToolAdapterInfo adapter) {
        this.add(((GuiNavigatorView)this.navigationView).getTree(), server, adapter);
    }

    public void addToolInstance(ServerID server, ToolInfo tool) {
        this.addToolInstance(((GuiNavigatorView)this.navigationView).getTree(), server, tool);
    }

    public void removeToolInstance(ServerID server, ToolID tool) {
        this.removeToolInstance(((GuiConnectionsView)this.connectionView).getTree(), server, tool);
        this.removeToolInstance(((GuiNavigatorView)this.navigationView).getTree(), server, tool);
    }

    public void connectToolInstance(ServerID server, ToolInfo tool) {
        this.addConnection(((GuiConnectionsView)this.connectionView).getTree(), server, tool);
    }

    public void disconnectToolInstance(ServerID server, ToolID tool) {
        ToolInstanceNode tN = (ToolInstanceNode)((GuiConnectionsView)this.connectionView).getTree().getSelectionPath().getLastPathComponent();
        Tree tree = ((GuiConnectionsView)this.connectionView).getTree();
        ((DefaultTreeModel)tree.getModel()).removeNodeFromParent(tN);
    }

    public void setToolView(SDTViewIF toolView) {
        JPanel panel = (JPanel)((GuiView)toolView).getPeer();
        this.toolView.removeAll();
        this.toolView.getPeer().add(panel);
        this.peer().validate();
    }

    public void resetToolView() {
        this.toolView.removeAll();
        this.peer().validate();
    }

    public void addView(SDTViewIF view) {
        view.setParent(this);
        this.getPerspectiveManager().registerView(view);
        if (view instanceof SDTNavigationViewIF) {
            this.navigationView = (GuiView)view;
            this.navigatorSplit.setTopComponent(new TitleViewDecorator(this.navigationView, ResourceManager.getString("Navigator.View.Title")));
        } else if (view instanceof SDTConnectionsViewIF) {
            this.connectionView = (GuiView)view;
            this.navigatorSplit.setBottomComponent(new TitleViewDecorator(this.connectionView, ResourceManager.getString("Connections.View.Title")));
        } else if (view instanceof SDTToolViewIF) {
            this.toolView = (GuiView)view;
            this.splitPane.setRightComponent(new TitleViewDecorator(this.toolView, ResourceManager.getString("Tool.View.Title")));
        }
    }

    public void focusGained(FocusEvent e) {
        this.navigationView.getParent().getPerspectiveManager().activate(this.navigationView);
    }

    public void focusLost(FocusEvent e) {
    }

    private void initGui() {
        this.splitPane = new JSplitPane();
        this.navigatorSplit = new JSplitPane(0);
        this.navigatorSplit.setDividerLocation(150);
        this.splitPane.setLeftComponent(this.navigatorSplit);
        this.splitPane.setDividerLocation(150);
        this.splitPane.setPreferredSize(new Dimension(600, 400));
        this.peer().setLayout(new GridBagLayout());
        this.peer().add((Component)this.splitPane, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.peer().addFocusListener(this);
    }

    private void add(Tree tree, ServerID server, ToolAdapterInfo adapter) {
        ToolNode tN = new ToolNode(adapter, server);
        ServerNode sN = this.findServerNode(this.getRootNode(tree), server);
        if (sN == null) {
            ServerElement sE = new ServerElement("localhost", "4711");
            sN = new ServerNode(sE, server);
            tree.addServerNode(sN);
        }
        tree.addToolNode(sN, tN);
    }

    private void addConnection(Tree tree, ServerID server, ToolInfo tool) {
        ToolNode tN;
        ToolElement tE = new ToolElement(tool.getID().toString());
        ServerNode sN = this.findServerNode(this.getRootNode(tree), server);
        if (sN == null) {
            RootNode rootN = this.getRootNode(((GuiNavigatorView)this.navigationView).getTree());
            ServerNode testN = this.findServerNode(rootN, server);
            sN = new ServerNode(testN.getServerElement(), server);
            tree.addServerNode(sN);
        }
        if ((tN = this.findToolType(sN, tool.getAdapterName())) == null) {
            ToolElement te = new ToolElement(tool.getAdapterName());
            tN = new ToolNode(tool.getAdapterInfo(), server);
            tree.addToolNode(sN, tN);
        }
        ToolInstanceNode inst = new ToolInstanceNode(tool, server);
        tree.addToolInstanceNode(inst, tN);
    }

    private void removeConnection(Tree tree) {
        ToolInstanceNode tN = (ToolInstanceNode)tree.getSelectionPath().getLastPathComponent();
        ((DefaultTreeModel)tree.getModel()).removeNodeFromParent(tN);
    }

    private void addToolInstance(Tree tree, ServerID server, ToolInfo tool) {
        ToolElement tE = new ToolElement(tool.getID().toString());
        ServerNode sN = this.findServerNode(this.getRootNode(tree), server);
        ToolNode tN = this.findToolType(sN, tool.getAdapterName());
        ToolInstanceNode inst = new ToolInstanceNode(tool, server);
        tree.addToolInstanceNode(inst, tN);
    }

    private void removeToolInstance(Tree tree, ServerID server, ToolID tool) {
        ServerNode sN = this.findServerNode(this.getRootNode(tree), server);
        if (sN != null) {
            for (int i = 0; i < sN.getChildCount(); ++i) {
                ToolNode node = (ToolNode)sN.getChildAt(i);
                for (int j = node.getChildCount() - 1; j >= 0; --j) {
                    ToolInstanceNode i_node = (ToolInstanceNode)node.getChildAt(j);
                    if (!i_node.getToolID().equals(tool)) continue;
                    ((DefaultTreeModel)tree.getModel()).removeNodeFromParent(i_node);
                }
            }
        }
    }

    private ServerNode findServerNode(RootNode root, ServerID server) {
        int count = root.getChildCount();
        ServerNode sN = null;
        for (int i = 0; i < count; ++i) {
            ServerNode node = (ServerNode)root.getChildAt(i);
            if (!node.getServerID().equals(server)) continue;
            sN = node;
            break;
        }
        return sN;
    }

    private ToolNode findToolType(ServerNode server, String name) {
        int count = server.getChildCount();
        ToolNode tN = null;
        for (int i = 0; i < count; ++i) {
            ToolNode node = (ToolNode)server.getChildAt(i);
            if (!node.getName().equals(name)) continue;
            tN = node;
            break;
        }
        return tN;
    }

    private RootNode getRootNode(Tree tree) {
        return (RootNode)tree.getModel().getRoot();
    }
}

