/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.ext.navigator.swing.controls;

import com.sap.sdt.engine.ext.navigator.controls.SDTNavigationViewIF;
import com.sap.sdt.gui.core.resources.ResourceConstants;
import com.sap.sdt.gui.core.swing.controls.GuiControlFactory;
import com.sap.sdt.gui.core.swing.controls.GuiMessageBox;
import com.sap.sdt.gui.core.swing.controls.GuiView;
import com.sap.sdt.gui.ext.navigator.swing.controls.tree.Tree;
import com.sap.sdt.gui.ext.navigator.swing.controls.tree.TreeConstants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.tree.TreePath;

public class GuiNavigatorView
extends GuiView
implements TreeConstants,
ResourceConstants,
SDTNavigationViewIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/ext/navigator/swing/controls/GuiNavigatorView.java#2 $";
    private Tree tree;
    private JButton b = new JButton("Test");

    public GuiNavigatorView() {
        this.tree = new Tree(0);
        JScrollPane treeScroll = new JScrollPane(this.tree);
        this.peer.setLayout(new BorderLayout());
        this.peer().add((Component)treeScroll, "Center");
        this.peer().add((Component)this.b, "South");
        this.b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GuiMessageBox m = (GuiMessageBox)GuiControlFactory.getInstance().createMessageBox();
                m.setTitle("Navigator View");
                m.setMessageText("Text ......");
                GuiNavigatorView.this.showPopup(m);
            }
        });
    }

    protected void performMouseReleased(MouseEvent e) {
        super.performMouseReleased(e);
        if (e.getSource().equals(this.tree)) {
            int row = this.tree.getRowForLocation(e.getX(), e.getY());
            if (row == -1) {
                return;
            }
            TreePath selPath = this.tree.getPathForLocation(e.getX(), e.getY());
            this.tree.setSelectionPath(selPath);
            if (e.isPopupTrigger()) {
                this.tree.showPopupMenu(e);
                this.tree.requestFocus();
            }
        }
    }

    public Tree getTree() {
        return this.tree;
    }

    public void activate() {
        super.activate();
        this.tree.requestFocus();
    }

    public void deactivate() {
        super.deactivate();
    }

    protected void performKeyPressed(KeyEvent e) {
        boolean isShift;
        super.performKeyPressed(e);
        Object source = e.getSource();
        int keyCode = e.getKeyCode();
        if (source instanceof Tree && (isShift = e.isShiftDown()) && keyCode == 121) {
            this.tree.showPopupMenu();
            e.consume();
        }
    }
}

