/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.views;

import com.sap.sdt.engine.core.controls.SDTActionListenerIF;
import com.sap.sdt.engine.core.controls.SDTViewIF;
import com.sap.sdt.engine.core.event.SDTActionEvent;
import com.sap.sdt.gui.core.images.ImageHolder;
import com.sap.sdt.gui.core.settings.GuiSettings;
import com.sap.sdt.gui.core.swing.controls.GuiActionListener;
import com.sap.sdt.gui.core.swing.controls.GuiButton;
import com.sap.sdt.gui.core.swing.controls.GuiPanel;
import com.sap.sdt.gui.core.swing.controls.GuiStyledText;
import com.sap.sdt.gui.core.swing.controls.GuiTextField;
import com.sap.sdt.gui.core.swing.controls.GuiView;
import com.sap.sdt.gui.core.swing.ui.Gui;
import com.sap.sdt.gui.core.swing.util.SwingToolkit;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.KeyboardFocusManager;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SingleToolLogonView
extends GuiView
implements SDTViewIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/core/swing/views/SingleToolLogonView.java#2 $";
    private static final GuiSettings settings = GuiSettings.getInstance();
    private static final int buttonSpace = settings.getInt("netweaver.button.space.side");
    private SDTActionListenerIF listener;
    private JPanel pn = this.peer();
    private JLabel lbTitle;
    private JLabel lbSubTitle;
    private GuiStyledText stDescription;
    private GuiTextField fieldHost;
    private GuiTextField fieldPort;
    private GuiButton buttonLogOn;
    private JDialog dialog = null;
    private static JFrame m_fMain;

    public SingleToolLogonView() {
        this.createDefaultLayout();
    }

    private void createDefaultLayout() {
        this.pn.setLayout(new BorderLayout());
        this.pn.setBackground(Color.white);
        this.addImage();
        this.addContent();
    }

    private void addImage() {
        JLabel lb = new JLabel(ImageHolder.NETWEAVER_IMAGE);
        lb.setHorizontalAlignment(2);
        lb.setAlignmentX(0.0f);
        SwingToolkit.setWidth(lb, Short.MAX_VALUE);
        this.pn.add((Component)lb, "North");
    }

    private void addContent() {
        JPanel pnContent = new JPanel();
        pnContent.setLayout(new BoxLayout(pnContent, 1));
        pnContent.setBackground(Color.white);
        pnContent.setBorder(BorderFactory.createEmptyBorder(settings.getInt("netweaver.content.space.top"), settings.getInt("netweaver.content.space.side"), settings.getInt("netweaver.content.space.bottom"), settings.getInt("netweaver.content.space.side")));
        this.lbTitle = new JLabel();
        this.lbTitle.setAlignmentX(0.0f);
        this.lbTitle.setFont(GuiSettings.getInstance().getFont("header.title.text"));
        this.lbTitle.setForeground(new Color(13158));
        pnContent.add(this.lbTitle);
        pnContent.add(Box.createVerticalStrut(settings.getInt("logon.title.subtitle.gap")));
        this.lbSubTitle = new JLabel();
        this.lbSubTitle.setAlignmentX(0.0f);
        this.lbSubTitle.setFont(GuiSettings.getInstance().getFont("header.subtitle.text"));
        this.lbSubTitle.setForeground(new Color(0xFF9900));
        pnContent.add(this.lbSubTitle);
        pnContent.add(Box.createVerticalStrut(settings.getInt("netweaver.description.form.gap")));
        GuiPanel panelForm = new GuiPanel();
        panelForm.setLayout(0);
        JPanel pnForm = (JPanel)panelForm.getPeer();
        pnForm.setBackground(settings.getBackground("form"));
        pnForm.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(), BorderFactory.createMatteBorder(settings.getInt("netweaver.form.space.top"), settings.getInt("netweaver.form.space.side"), settings.getInt("netweaver.form.space.bottom"), settings.getInt("netweaver.form.space.side"), settings.getBackground("form"))));
        this.stDescription = new GuiStyledText();
        this.stDescription.getPeer().setAlignmentX(0.0f);
        pnForm.add(this.stDescription.getPeer());
        pnForm.add(Box.createVerticalStrut(settings.getInt("netweaver.content.space.bottom")));
        this.fieldHost = new GuiTextField();
        this.fieldHost.setCaption("Host", 'H');
        this.fieldHost.setMaxLength(30);
        panelForm.add(this.fieldHost);
        this.fieldPort = new GuiTextField();
        this.fieldPort.setCaption("Port", 'P');
        this.fieldPort.setMaxLength(30);
        panelForm.add(this.fieldPort);
        pnForm.add(Box.createVerticalStrut(settings.getInt("logon.form.button.gap")));
        JPanel pnButton = new JPanel();
        pnButton.setLayout(new BoxLayout(pnButton, 0));
        this.buttonLogOn = new GuiButton();
        this.buttonLogOn.setCaption("Log on", 'L');
        JButton bnLogOn = (JButton)this.buttonLogOn.getPeer();
        int space = settings.getInt("logon.button.space.side");
        SwingToolkit.setWidth(bnLogOn, bnLogOn.getPreferredSize().width + 2 * space);
        pnButton.add(bnLogOn);
        pnForm.add(pnButton);
        pnContent.add(pnForm);
        pnContent.add(Box.createVerticalStrut(settings.getInt("netweaver.form.navigation.gap")));
        JPanel pnCopyright = new JPanel();
        pnCopyright.setLayout(new BoxLayout(pnCopyright, 0));
        pnCopyright.setAlignmentX(0.0f);
        pnCopyright.setOpaque(false);
        JLabel lbCopyRight = new JLabel("Copyright \u00a9 2004 SAP AG. All Rights Reserved.");
        lbCopyRight.setAlignmentY(1.0f);
        lbCopyRight.setFont(GuiSettings.getInstance().getFont("logon.copyright.label"));
        pnCopyright.add(lbCopyRight);
        pnCopyright.add(Box.createHorizontalGlue());
        JLabel lbSAPLogo = new JLabel(ImageHolder.SAPLOGO_SMALL_ICON);
        lbSAPLogo.setAlignmentY(1.0f);
        pnCopyright.add(lbSAPLogo);
        pnContent.add(pnCopyright);
        this.pn.add((Component)pnContent, "Center");
    }

    public void setListener(SDTActionListenerIF listener) {
        this.buttonLogOn.addActionListener(listener);
    }

    public void setTitle(String text) {
        this.lbTitle.setText(SwingToolkit.getPlainText(text));
    }

    public void setSubTitle(String text) {
        this.lbSubTitle.setText(text);
    }

    public void setDescription(String text) {
        this.stDescription.setText(text);
    }

    public void setHost(String host) {
        this.fieldHost.setText(host);
    }

    public String getHost() {
        return this.fieldHost.getText().trim();
    }

    public void setPort(int port) {
        this.fieldPort.setText(String.valueOf(port));
    }

    public int getPort() {
        try {
            return Integer.parseInt(this.fieldPort.getText().trim());
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public void refresh() {
        if (this.getParent() != null) {
            JFrame frame = ((Gui)this.getParent().getParent()).getPeer();
            frame.getRootPane().setDefaultButton((JButton)this.buttonLogOn.getPeer());
        }
        this.setFocus();
    }

    private void setFocus() {
        this.fieldHost.getPeer().requestFocusInWindow();
    }

    public void setWaitCursor(boolean isWaitCursor) {
        JFrame frame = ((Gui)this.getParent().getParent()).getPeer();
        if (isWaitCursor) {
            Cursor cursor = Cursor.getPredefinedCursor(3);
            frame.getGlassPane().setVisible(true);
            frame.getGlassPane().setCursor(cursor);
            KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
        } else {
            frame.getGlassPane().setVisible(false);
            this.setFocus();
        }
    }

    public static void test() {
        JFrame f = new JFrame("Single Tool Login View");
        SingleToolLogonView view = new SingleToolLogonView();
        MyGuiActionListener listener = new MyGuiActionListener(view);
        view.setListener(listener);
        view.setTitle("SAP NetWeaver");
        view.setSubTitle("SAPinst Installation GUI");
        view.setDescription("<html>Welcome to the SAPinst installation.<br>Enter the host name and TCP/IP port of the running SAPinst installation tool you want to log on to.</html>");
        f.setContentPane(view.getPeer());
        f.setLocation(300, 100);
        f.setSize(510, 460);
        f.show();
        m_fMain = f;
    }

    public static void main(String[] args) {
        GuiSettings.getInstance();
        SingleToolLogonView.test();
        m_fMain.setDefaultCloseOperation(3);
    }

    private static class MyGuiActionListener
    extends GuiActionListener {
        private final SingleToolLogonView view;

        public MyGuiActionListener(SingleToolLogonView view) {
            this.view = view;
        }

        public void actionPerformed(SDTActionEvent e) {
            System.out.println("host=" + this.view.getHost());
            System.out.println("port=" + this.view.getPort());
        }
    }
}

