/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicHTML;

public class SwingToolkit {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/core/swing/util/SwingToolkit.java#2 $";
    private static final Border border = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.red), BorderFactory.createEmptyBorder(1, 1, 1, 1));

    public static String getPlainText(String markupText) {
        if (markupText == null) {
            return null;
        }
        if (!BasicHTML.isHTMLString(markupText = markupText.trim())) {
            return markupText;
        }
        int endPos = markupText.toLowerCase().indexOf("</html>", 6);
        String plainText = endPos == -1 ? markupText.substring(6) : markupText.substring(6, endPos);
        return plainText;
    }

    public static void setMinWidth(JComponent comp, int width) {
        comp.setMinimumSize(new Dimension(width, comp.getMinimumSize().height));
    }

    public static void setPrefWidth(JComponent comp, int width) {
        comp.setPreferredSize(new Dimension(width, comp.getPreferredSize().height));
    }

    public static void setMaxWidth(JComponent comp, int width) {
        comp.setMaximumSize(new Dimension(width, comp.getMaximumSize().height));
    }

    public static void setWidth(JComponent comp, int width) {
        SwingToolkit.setMinWidth(comp, width);
        SwingToolkit.setPrefWidth(comp, width);
        SwingToolkit.setMaxWidth(comp, width);
    }

    public static void fixWidth(JComponent comp) {
        SwingToolkit.setWidth(comp, comp.getPreferredSize().width);
    }

    public static void setMinHeight(JComponent comp, int height) {
        comp.setMinimumSize(new Dimension(comp.getMinimumSize().width, height));
    }

    public static void setPrefHeight(JComponent comp, int height) {
        comp.setPreferredSize(new Dimension(comp.getPreferredSize().width, height));
    }

    public static void setMaxHeight(JComponent comp, int height) {
        comp.setMaximumSize(new Dimension(comp.getMaximumSize().width, height));
    }

    public static void setHeight(JComponent comp, int height) {
        SwingToolkit.setMinHeight(comp, height);
        SwingToolkit.setPrefHeight(comp, height);
        SwingToolkit.setMaxHeight(comp, height);
    }

    public static void fixHeight(JComponent comp) {
        SwingToolkit.setHeight(comp, comp.getPreferredSize().height);
    }

    public static void setHighlightBorder(JComponent comp) {
        Border existingBorder = comp.getBorder();
        comp.putClientProperty("originalBorder", existingBorder);
        comp.setBorder(border);
    }

    public static void removeHighlightBorder(JComponent comp) {
        Border currentBorder = comp.getBorder();
        if (currentBorder == border) {
            comp.setBorder((Border)comp.getClientProperty("originalBorder"));
        }
    }

    public static void setLocationRelativeTo(Component c, Component invoker) {
        if (invoker == null) {
            Dimension paneSize = c.getSize();
            Dimension screenSize = c.getToolkit().getScreenSize();
            c.setLocation((screenSize.width - paneSize.width) / 2, (screenSize.height - paneSize.height) / 2);
            return;
        }
        Object root = null;
        Dimension invokerSize = invoker.getSize();
        Point invokerScreenLocation = new Point(0, 0);
        for (Component tc = invoker; tc != null; tc = tc.getParent()) {
            Point tcl = tc.getLocation();
            invokerScreenLocation.x += tcl.x;
            invokerScreenLocation.y += tcl.y;
            if (tc == root) break;
        }
        Rectangle dialogBounds = c.getBounds();
        int dx = invokerScreenLocation.x + (invokerSize.width - dialogBounds.width >> 1);
        int dy = invokerScreenLocation.y + (invokerSize.height - dialogBounds.height >> 1);
        Dimension ss = c.getToolkit().getScreenSize();
        if (dy + dialogBounds.height > ss.height) {
            dy = ss.height - dialogBounds.height;
            int n = dx = invokerScreenLocation.x < ss.width >> 1 ? invokerScreenLocation.x + invokerSize.width : invokerScreenLocation.x - dialogBounds.width;
        }
        if (dx + dialogBounds.width > ss.width) {
            dx = ss.width - dialogBounds.width;
        }
        if (dx < 0) {
            dx = 0;
        }
        if (dy < 0) {
            dy = 0;
        }
        c.setLocation(dx, dy);
    }

    public static void print(Component comp) {
        JComponent jcomp;
        if (comp == null) {
            System.out.println("component = null");
            return;
        }
        System.out.println("class name=" + comp.getClass().getName());
        System.out.println("min size : width=" + comp.getMinimumSize().width + "   height=" + comp.getMinimumSize().height);
        System.out.println("pref size: width=" + comp.getPreferredSize().width + "   height=" + comp.getPreferredSize().height);
        System.out.println("max size : width=" + comp.getMaximumSize().width + "   height=" + comp.getMaximumSize().height);
        System.out.println("real size : width=" + comp.getSize().width + "   height=" + comp.getSize().height);
        if (comp instanceof JComponent && (jcomp = (JComponent)comp).getComponentCount() > 0) {
            System.out.println("children=" + jcomp.getComponentCount());
        }
    }
}

