/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.UIManager;

public class MinSizeFrame
extends JFrame {
    private static final FontMetrics m_titleFontMetrics = new JFrame().getFontMetrics(UIManager.getFont("InternalFrame.titleFont"));
    private Window m_window = this;
    private int m_titleWidth;
    private Dimension m_minSize = null;
    private final ComponentAdapter resizeListener = new ResizeListener();

    public MinSizeFrame() {
        this.init();
    }

    public MinSizeFrame(String title) {
        super(title);
        this.init();
    }

    public MinSizeFrame(GraphicsConfiguration gc) {
        super(gc);
        this.init();
    }

    public MinSizeFrame(String title, GraphicsConfiguration gc) {
        super(title, gc);
        this.init();
    }

    protected void init() {
        String title = this.getTitle();
        if (title != null && title.length() > 0) {
            this.m_titleWidth = m_titleFontMetrics.stringWidth(this.getTitle()) + 50;
        }
        this.addComponentListener(this.resizeListener);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 27) {
                    MinSizeFrame.this.close();
                }
            }
        });
    }

    public void setMinimumSize(Dimension minSize) {
        this.m_minSize = minSize.width > this.m_titleWidth ? minSize : new Dimension(this.m_titleWidth, minSize.height);
    }

    public Dimension getMinimumSize() {
        if (this.m_minSize != null) {
            return this.m_minSize;
        }
        Dimension minSize = super.getMinimumSize();
        if (minSize.width < this.m_titleWidth) {
            minSize = new Dimension(this.m_titleWidth, minSize.height);
        }
        return minSize;
    }

    public void setLocationRelativeTo(Component invoker) {
        if (invoker == null) {
            Dimension paneSize = this.getSize();
            Dimension screenSize = this.getToolkit().getScreenSize();
            this.setLocation((screenSize.width - paneSize.width) / 2, (screenSize.height - paneSize.height) / 2);
            return;
        }
        Object root = null;
        Dimension invokerSize = invoker.getSize();
        Point invokerScreenLocation = new Point(0, 0);
        for (Component tc = invoker; tc != null; tc = tc.getParent()) {
            Point tcl = tc.getLocation();
            invokerScreenLocation.x += tcl.x;
            invokerScreenLocation.y += tcl.y;
            if (tc == root) break;
        }
        Rectangle dialogBounds = this.getBounds();
        int dx = invokerScreenLocation.x + (invokerSize.width - dialogBounds.width >> 1);
        int dy = invokerScreenLocation.y + (invokerSize.height - dialogBounds.height >> 1);
        Dimension ss = this.getToolkit().getScreenSize();
        if (dy + dialogBounds.height > ss.height) {
            dy = ss.height - dialogBounds.height;
            int n = dx = invokerScreenLocation.x < ss.width >> 1 ? invokerScreenLocation.x + invokerSize.width : invokerScreenLocation.x - dialogBounds.width;
        }
        if (dx + dialogBounds.width > ss.width) {
            dx = ss.width - dialogBounds.width;
        }
        if (dx < 0) {
            dx = 0;
        }
        if (dy < 0) {
            dy = 0;
        }
        this.setLocation(dx, dy);
    }

    public void close() {
        this.processWindowEvent(new WindowEvent(this.m_window, 201));
    }

    private static class ResizeListener
    extends ComponentAdapter {
        private ResizeListener() {
        }

        public void componentResized(ComponentEvent e) {
            Component comp = e.getComponent();
            Dimension size = comp.getSize();
            Dimension minSize = comp.getMinimumSize();
            int newWidth = -1;
            int newHeight = -1;
            newWidth = Math.max(minSize.width, size.width);
            newHeight = Math.max(minSize.height, size.height);
            if (newWidth != size.width || newHeight != size.height) {
                comp.setSize(newWidth, newHeight);
            }
        }
    }
}

