/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.util;

import com.sap.sdt.gui.core.resources.ResourceManager;
import com.sap.sdt.gui.core.swing.ui.GuiAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;

public class MenuCreator {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/core/swing/util/MenuCreator.java#2 $";
    private static final String MNEMONIC_SUFFIX = "_MNEMONIC";
    private static final String ACCELERATOR_SUFFIX = "_ACCELERATOR";
    private static final String SHORT_DESCRIPTION_SUFFIX = "_SHORT_DESCRIPTION";
    private static final String MENU_PREFIX = "MENU_";
    public static final String NAME_SUFFIX = "_NAME";
    public static final int MENU_ITEM_TYPE_DEFAULT = 0;
    public static final int MENU_ITEM_TYPE_RADIO_BUTTOM = 1;
    public static final int MENU_ITEM_TYPE_CHECKBOX = 2;

    public static JMenu createJMenu(String name) {
        JMenu menu = new JMenu(ResourceManager.getString(MENU_PREFIX + name + NAME_SUFFIX));
        String mnemonic = ResourceManager.getString(MENU_PREFIX + name + MNEMONIC_SUFFIX);
        if (mnemonic != null && mnemonic.length() > 0) {
            menu.setMnemonic(mnemonic.charAt(0));
        }
        return menu;
    }

    public static JMenuItem addSubmenuTo(JMenu menu, Action action, int type) {
        JMenuItem item = null;
        switch (type) {
            case 0: {
                item = new JMenuItem(action);
                break;
            }
            case 1: {
                item = new JRadioButtonMenuItem(action);
                break;
            }
            case 2: {
                item = new JCheckBoxMenuItem(action);
                break;
            }
        }
        menu.add(item);
        item.getAccessibleContext().setAccessibleDescription((String)action.getValue("ShortDescription"));
        return item;
    }

    public static JMenuItem createMenuItem(String name, int type) {
        JMenuItem item = null;
        GuiAction action = new GuiAction(null, name, null);
        switch (type) {
            case 0: {
                item = new JMenuItem(action);
                break;
            }
            case 1: {
                item = new JRadioButtonMenuItem(action);
                break;
            }
            case 2: {
                item = new JCheckBoxMenuItem(action);
                break;
            }
        }
        item.getAccessibleContext().setAccessibleDescription((String)action.getValue("ShortDescription"));
        return item;
    }

    public static JMenuItem createMenuItem(String name) {
        return MenuCreator.createMenuItem(name, 0);
    }

    public static void addSubmenuTo(JMenu menu, JMenuItem item) {
        menu.add(item);
    }
}

