/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.util;

import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

public abstract class GuiRunnable
implements Runnable {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/core/swing/util/GuiRunnable.java#2 $";
    private static Object[] EMPTY_ARRAY = new Object[0];
    private Object[] parameters;
    private List returnValues;

    public GuiRunnable() {
    }

    public GuiRunnable(Object[] parameters) {
        this.parameters = parameters;
    }

    public GuiRunnable(boolean parameter) {
        this(new Object[]{parameter ? Boolean.TRUE : Boolean.FALSE});
    }

    public GuiRunnable(int parameter) {
        this(new Object[]{new Integer(parameter)});
    }

    public GuiRunnable(char parameter) {
        this(new Object[]{new Character(parameter)});
    }

    public GuiRunnable(Object parameter) {
        this(new Object[]{parameter});
    }

    protected boolean getBooleanParameter() {
        return this.getBooleanParameter(0);
    }

    protected boolean getBooleanParameter(int parameterIndex) {
        return this.getBoolean(this.parameters[parameterIndex]);
    }

    protected int getIntParameter() {
        return this.getIntParameter(0);
    }

    protected int getIntParameter(int parameterIndex) {
        return this.getInt(this.parameters[parameterIndex]);
    }

    protected char getCharParameter() {
        return this.getCharParameter(0);
    }

    protected char getCharParameter(int parameterIndex) {
        return this.getChar(this.parameters[parameterIndex]);
    }

    protected String getStringParameter() {
        return this.getStringParameter(0);
    }

    protected String getStringParameter(int parameterIndex) {
        return this.getString(this.parameters[parameterIndex]);
    }

    protected Object getParameter() {
        return this.getParameter(0);
    }

    protected Object getParameter(int parameterIndex) {
        return this.parameters[parameterIndex];
    }

    protected void addReturnValue(boolean value) {
        this.returnValues = this.createLazyList(this.returnValues);
        this.returnValues.add(value ? Boolean.TRUE : Boolean.FALSE);
    }

    protected void addReturnValue(int value) {
        this.returnValues = this.createLazyList(this.returnValues);
        this.returnValues.add(new Integer(value));
    }

    protected void addReturnValue(char value) {
        this.returnValues = this.createLazyList(this.returnValues);
        this.returnValues.add(new Character(value));
    }

    protected void addReturnValue(Object value) {
        this.returnValues = this.createLazyList(this.returnValues);
        this.returnValues.add(value);
    }

    public int sizeReturnValues() {
        return this.returnValues != null ? this.returnValues.size() : 0;
    }

    public boolean getBooleanReturnValue() {
        return this.getBooleanReturnValue(0);
    }

    public boolean getBooleanReturnValue(int returnValueIndex) {
        return this.getBoolean(this.returnValues.get(returnValueIndex));
    }

    public int getIntReturnValue() {
        return this.getIntReturnValue(0);
    }

    public int getIntReturnValue(int returnValueIndex) {
        return this.getInt(this.returnValues.get(returnValueIndex));
    }

    public char getCharReturnValue() {
        return this.getCharReturnValue(0);
    }

    public char getCharReturnValue(int returnValueIndex) {
        return this.getChar(this.returnValues.get(returnValueIndex));
    }

    public String getStringReturnValue() {
        return this.getStringReturnValue(0);
    }

    public String getStringReturnValue(int returnValueIndex) {
        return this.getString(this.returnValues.get(returnValueIndex));
    }

    public Object getReturnValue() {
        return this.getReturnValue(0);
    }

    public Object getReturnValue(int returnValueIndex) {
        return this.returnValues.get(returnValueIndex);
    }

    public void startAndWait() {
        if (EventQueue.isDispatchThread()) {
            this.run();
        } else {
            try {
                EventQueue.invokeAndWait(this);
            }
            catch (InterruptedException e) {
                System.err.println("GuiRunnable invokeAndWait() was interrupted:");
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                System.err.println("Exception during GuiRunnable.run() :");
                e.printStackTrace();
            }
        }
    }

    public void startLater() {
        EventQueue.invokeLater(this);
    }

    private boolean getBoolean(Object value) {
        return (Boolean)value;
    }

    private int getInt(Object value) {
        return (Integer)value;
    }

    private char getChar(Object value) {
        return ((Character)value).charValue();
    }

    private String getString(Object value) {
        return (String)value;
    }

    private List createLazyList(List list) {
        if (list == null) {
            list = new ArrayList(1);
        }
        return list;
    }
}

