/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.ui.decorator;

import com.sap.sdt.gui.core.swing.controls.GuiView;
import com.sap.sdt.gui.core.swing.ui.decorator.ViewDecorator;
import com.sap.sdt.gui.core.swing.ui.event.ActivationEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;

public class TitleViewDecorator
extends ViewDecorator {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/core/swing/ui/decorator/TitleViewDecorator.java#2 $";
    private GradientToolBar toolBar;
    private JLabel title;
    private Color toolBar_bg;
    private Color toolBar_fg;

    public TitleViewDecorator(GuiView view, String title) {
        super(view);
        this.initToolBar(title);
        this.add((Component)this.toolBar, "First");
    }

    private void initToolBar(String _title) {
        this.toolBar = new GradientToolBar();
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.title = new JLabel(_title);
        this.title.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.toolBar.add((Component)this.title, "West");
        this.toolBar.setBackground(this.toolBar_bg);
        this.toolBar_fg = this.title.getForeground();
        this.toolBar.setBorder(new LineBorder(Color.gray, 1, false));
        this.toolBar.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                TitleViewDecorator.this.view.getParent().getPerspectiveManager().activate(TitleViewDecorator.this.view);
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }
        });
    }

    public void activationChanged(ActivationEvent event) {
        int type = event.getType();
        if (type == 1) {
            this.toolBar.setBackground(Color.decode("#172972"));
            this.title.setForeground(Color.white);
        } else if (type == 0) {
            this.toolBar.setBackground(this.toolBar_bg);
            this.title.setForeground(this.toolBar_fg);
        }
    }

    private static class GradientToolBar
    extends JToolBar {
        private GradientToolBar() {
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Color control = UIManager.getColor("control");
            int width = this.getWidth();
            int height = this.getHeight();
            Graphics2D g2 = (Graphics2D)g;
            Paint storedPaint = g2.getPaint();
            g2.setPaint(new GradientPaint(0.0f, 0.0f, this.getBackground(), width, 0.0f, control));
            g2.fillRect(0, 0, width, height);
            g2.setPaint(storedPaint);
        }
    }
}

