/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.ui;

import com.sap.sdt.gui.core.resources.ResourceConstants;
import com.sap.sdt.gui.core.resources.ResourceManager;
import com.sap.sdt.gui.core.settings.GuiSettings;
import com.sap.sdt.gui.core.swing.ui.AbstractDialog;
import com.sap.sdt.gui.core.swing.ui.GuiAction;
import com.sap.sdt.gui.core.swing.ui.GuiConstants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class GuiStartToolDialog
extends AbstractDialog
implements ActionListener,
ResourceConstants,
GuiConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/core/swing/ui/GuiStartToolDialog.java#2 $";
    private JTextField port_tf;
    private JTextField host_tf;
    private JButton startButton;
    private JButton cancelButton;
    private boolean isStarted = false;

    public GuiStartToolDialog(JFrame frame) {
        super(frame, ResourceManager.getString("Start.Tool.Dialog.Title"), true);
        JPanel tfPanel = new JPanel();
        tfPanel.setBorder(BorderFactory.createEtchedBorder());
        tfPanel.setLayout(new GridBagLayout());
        JLabel port_label = new JLabel(ResourceManager.getString("Start.Tool.Dialog.ToolPort.Label"));
        tfPanel.add((Component)port_label, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.port_tf = new JTextField();
        this.port_tf.setText("21212");
        port_label.setLabelFor(this.port_tf);
        this.port_tf.setPreferredSize(new Dimension(200, 21));
        tfPanel.add((Component)this.port_tf, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        JLabel host_label = new JLabel(ResourceManager.getString("Start.Tool.Dialog.ToolHost.Label"));
        tfPanel.add((Component)host_label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.host_tf = new JTextField();
        this.host_tf.setText("localhost");
        host_label.setLabelFor(this.host_tf);
        this.host_tf.setPreferredSize(new Dimension(200, 21));
        tfPanel.add((Component)this.host_tf, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        JPanel butPanel = new JPanel();
        butPanel = new JPanel();
        butPanel.setLayout(new FlowLayout(2));
        GuiAction startAction = new GuiAction(this, "START_INSTANCE", null);
        this.startButton = new JButton(startAction);
        GuiAction cancelAction = new GuiAction(this, "CANCEL", null);
        butPanel.add(this.startButton);
        this.cancelButton = new JButton(cancelAction);
        Dimension dim = this.cancelButton.getPreferredSize();
        this.cancelButton.setPreferredSize(new Dimension(dim.width + 2 * GuiSettings.getInstance().getInt("button.space.side"), dim.height));
        butPanel.add(this.cancelButton);
        this.startButton.setPreferredSize(new Dimension(this.cancelButton.getPreferredSize().width, this.startButton.getPreferredSize().height));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)tfPanel, "North");
        this.getContentPane().add((Component)butPanel, "South");
        this.pack();
    }

    protected void performEnterAction(KeyEvent e) {
        if (this.getFocusOwner() != this.cancelButton) {
            this.startButton.doClick();
        } else {
            this.cancelButton.doClick();
        }
    }

    protected void performEscapeAction(KeyEvent e) {
        super.performEscapeAction(e);
        this.isStarted = false;
    }

    protected void performWindowClosingAction() {
        this.cancelButton.doClick();
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("START_INSTANCE")) {
            this.okAction();
        } else if (cmd.equals("CANCEL")) {
            this.cancelAction();
        }
    }

    private void cancelAction() {
        this.setVisible(false);
        this.isStarted = false;
    }

    private void okAction() {
        if (this.port_tf.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, ResourceManager.getString("Message.Input.Port"), ResourceManager.getString("Input.Dialog.Title"), 0);
            return;
        }
        if (this.host_tf.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, ResourceManager.getString("Message.Input.Host"), ResourceManager.getString("Input.Dialog.Title"), 0);
            return;
        }
        this.isStarted = true;
        this.setVisible(false);
    }

    public boolean showDialog() {
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
        return this.isStarted;
    }

    public int getPort() {
        int port = 21212;
        try {
            port = Integer.parseInt(this.port_tf.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return port;
    }

    public String getHost() {
        return this.host_tf.getText();
    }
}

