/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.ui;

import com.sap.sdt.gui.core.resources.ResourceConstants;
import com.sap.sdt.gui.core.resources.ResourceManager;
import com.sap.sdt.gui.core.swing.ui.AbstractDialog;
import com.sap.sdt.gui.core.swing.ui.GuiConstants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class GuiConnectInstanceDialog
extends AbstractDialog
implements ActionListener,
ResourceConstants,
GuiConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/core/swing/ui/GuiConnectInstanceDialog.java#2 $";
    private JComboBox role_cb;
    private JButton startButton;
    private JButton cancelButton;
    private boolean isStarted = false;

    public GuiConnectInstanceDialog(JFrame frame) {
        super(frame, ResourceManager.getString("Connect.Tool.Dialog.Title"), true);
        JPanel tfPanel = new JPanel();
        tfPanel.setBorder(BorderFactory.createEtchedBorder());
        tfPanel.setLayout(new GridBagLayout());
        JLabel role_label = new JLabel(ResourceManager.getString("Connect.Tool.Dialog.Role.Text"));
        tfPanel.add((Component)role_label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.role_cb = new JComboBox();
        role_label.setLabelFor(this.role_cb);
        this.role_cb.setPreferredSize(new Dimension(200, 21));
        tfPanel.add((Component)this.role_cb, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        JPanel butPanel = new JPanel();
        butPanel = new JPanel();
        butPanel.setLayout(new FlowLayout());
        this.startButton = new JButton(ResourceManager.getString("Connect.Dialog.Connect.Button.Text"));
        this.startButton.setActionCommand("CONNECT");
        this.startButton.addActionListener(this);
        butPanel.add(this.startButton);
        this.cancelButton = new JButton(ResourceManager.getString("Cancel.Button.Text"));
        this.cancelButton.setActionCommand("CANCEL");
        this.cancelButton.addActionListener(this);
        butPanel.add(this.cancelButton);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)tfPanel, "Center");
        this.getContentPane().add((Component)butPanel, "South");
        this.pack();
    }

    protected void performEnterAction(KeyEvent e) {
        this.startButton.doClick();
    }

    protected void performEscapeAction(KeyEvent e) {
        super.performEscapeAction(e);
        this.isStarted = false;
    }

    protected void performWindowClosingAction() {
        this.cancelButton.doClick();
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("CONNECT")) {
            this.okAction();
        } else if (cmd.equals("CANCEL")) {
            this.cancelAction();
        }
    }

    private void cancelAction() {
        this.setVisible(false);
        this.isStarted = false;
    }

    private void okAction() {
        if (((String)this.role_cb.getSelectedItem()).trim().length() == 0) {
            JOptionPane.showMessageDialog(this, ResourceManager.getString("Message.Input.Port"), ResourceManager.getString("Input.Dialog.Title"), 0);
            return;
        }
        this.setVisible(false);
        this.isStarted = true;
    }

    public boolean showDialog() {
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
        return this.isStarted;
    }

    public String getRole() {
        return (String)this.role_cb.getSelectedItem();
    }

    public void setRoles(String[] roles) {
        for (int i = 0; i < roles.length; ++i) {
            this.role_cb.addItem(roles[i]);
        }
    }
}

