/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.ui;

import com.sap.sdt.gui.core.resources.ResourceConstants;
import com.sap.sdt.gui.core.resources.ResourceManager;
import com.sap.sdt.gui.core.swing.ui.AbstractDialog;
import com.sap.sdt.gui.core.swing.ui.GuiConstants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class GuiConnectDialog
extends AbstractDialog
implements ActionListener,
ResourceConstants,
GuiConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/core/swing/ui/GuiConnectDialog.java#2 $";
    private JTextField host_tf;
    private JTextField port_tf;
    private JButton connectButton;
    private JButton cancelButton;
    private boolean isOk = false;

    public GuiConnectDialog(JFrame frame) {
        super(frame, ResourceManager.getString("Connect.Dialog.Title"), true);
        this.getAccessibleContext().setAccessibleDescription(ResourceManager.getString("Connect.Dialog.Description"));
        JPanel tfPanel = new JPanel();
        tfPanel.setBorder(BorderFactory.createEtchedBorder());
        tfPanel.setLayout(new GridBagLayout());
        JLabel host_label = new JLabel(ResourceManager.getString("Connect.Dialog.ServerHost.Label.Text"));
        tfPanel.add((Component)host_label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.host_tf = new JTextField();
        this.host_tf.setPreferredSize(new Dimension(200, 21));
        this.host_tf.getAccessibleContext().setAccessibleName(ResourceManager.getString("Connect.Dialog.ServerHost.TextField.AccessibleName"));
        this.host_tf.getAccessibleContext().setAccessibleDescription(ResourceManager.getString("Connect.Dialog.ServerHost.TextField.AccessibleDescription"));
        tfPanel.add((Component)this.host_tf, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        JLabel port_label = new JLabel(ResourceManager.getString("Connect.Dialog.ServerPort.Label.Text"));
        tfPanel.add((Component)port_label, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.port_tf = new JTextField();
        this.port_tf.setPreferredSize(new Dimension(200, 21));
        this.port_tf.getAccessibleContext().setAccessibleName(ResourceManager.getString("Connect.Dialog.ServerPort.TextField.AccessibleName"));
        this.port_tf.getAccessibleContext().setAccessibleDescription(ResourceManager.getString("Connect.Dialog.ServerPort.TextField.AccessibleDescription"));
        tfPanel.add((Component)this.port_tf, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        port_label.setLabelFor(this.port_tf);
        port_label.setDisplayedMnemonic(ResourceManager.getString("Connect.Dialog.ServerPort.Label.Mnemonic").charAt(0));
        port_label.getAccessibleContext().setAccessibleDescription("Connect.Dialog.ServerPort.TextField.AccessibleDescription");
        host_label.setLabelFor(this.host_tf);
        host_label.setDisplayedMnemonic(ResourceManager.getString("Connect.Dialog.ServerHost.Label.Mnemonic").charAt(0));
        host_label.getAccessibleContext().setAccessibleDescription("Connect.Dialog.ServerPort.TextField.AccessibleDescription");
        JPanel butPanel = new JPanel();
        butPanel = new JPanel();
        butPanel.setLayout(new FlowLayout());
        this.connectButton = new JButton(ResourceManager.getString("Connect.Dialog.Connect.Button.Text"));
        this.connectButton.setActionCommand("CONNECT");
        this.connectButton.setToolTipText(ResourceManager.getString("Connect.Dialog.Connect.Button.ToolTip"));
        this.connectButton.addActionListener(this);
        butPanel.add(this.connectButton);
        this.cancelButton = new JButton(ResourceManager.getString("Cancel.Button.Text"));
        this.cancelButton.setActionCommand("CANCEL");
        this.cancelButton.addActionListener(this);
        this.cancelButton.setToolTipText(ResourceManager.getString("Cancel.Button.ToolTip"));
        butPanel.add(this.cancelButton);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)tfPanel, "Center");
        this.getContentPane().add((Component)butPanel, "South");
        this.pack();
    }

    protected void performEnterAction(KeyEvent e) {
        this.connectButton.doClick();
    }

    protected void performEscapeAction(KeyEvent e) {
        super.performEscapeAction(e);
        this.isOk = false;
    }

    protected void performWindowClosingAction() {
        this.cancelButton.doClick();
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("CONNECT")) {
            this.okAction();
        } else if (cmd.equals("CANCEL")) {
            this.cancelAction();
        }
    }

    private void cancelAction() {
        this.setVisible(false);
        this.isOk = false;
    }

    private void okAction() {
        if (this.host_tf.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, ResourceManager.getString("Message.Input.Host"), ResourceManager.getString("Input.Dialog.Title"), 0);
            return;
        }
        if (this.port_tf.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, ResourceManager.getString("Message.Input.Port"), ResourceManager.getString("Input.Dialog.Title"), 0);
            return;
        }
        this.setVisible(false);
        this.isOk = true;
    }

    public boolean showDialog() {
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
        return this.isOk;
    }

    public String getHost() {
        return this.host_tf.getText();
    }

    public int getPort() {
        return new Integer(this.port_tf.getText());
    }
}

