/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.ui;

import com.sap.sdt.gui.core.resources.ResourceManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public class GuiAction
extends AbstractAction {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/core/swing/ui/GuiAction.java#2 $";
    private static final String MNEMONIC_SUFFIX = "_MNEMONIC";
    private static final String ACCELERATOR_SUFFIX = "_ACCELERATOR";
    private static final String SHORT_DESCRIPTION_SUFFIX = "_SHORT_DESCRIPTION";
    private static final String MENU_PREFIX = "MENU_";
    private static final String ACTION_PREFIX = "ACTION_";
    private static final String COMMAND_SUFFIX = "_COMMAND";
    private static final String NAME_SUFFIX = "_NAME";
    private String command;
    private ActionListener listener;

    public GuiAction(ActionListener listener, String name, Icon icon) {
        super(ResourceManager.getString(ACTION_PREFIX + name + NAME_SUFFIX), icon);
        KeyStroke stroke;
        this.listener = listener;
        this.command = name;
        String shortDescription = ResourceManager.getString(ACTION_PREFIX + name + SHORT_DESCRIPTION_SUFFIX);
        if (shortDescription != null && shortDescription.length() > 0) {
            this.putValue("ShortDescription", shortDescription);
        }
        String mnemonic = ResourceManager.getString(ACTION_PREFIX + name + MNEMONIC_SUFFIX);
        String accelerator = ResourceManager.getString(ACTION_PREFIX + name + ACCELERATOR_SUFFIX);
        if (accelerator != null && accelerator.length() > 0 && (stroke = KeyStroke.getKeyStroke(accelerator)) != null) {
            this.putValue("AcceleratorKey", stroke);
        }
        if (mnemonic != null && mnemonic.length() > 0) {
            int m = mnemonic.charAt(0);
            if (m >= 97 && m <= 122) {
                m -= 32;
            }
            this.putValue("MnemonicKey", new Integer(m));
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (this.listener != null) {
            this.listener.actionPerformed(new ActionEvent(e.getSource(), e.getID(), this.command, e.getModifiers()));
        }
    }

    public String getCommand() {
        return this.command;
    }

    public ActionListener getListener() {
        return this.listener;
    }

    public void setCommand(String string) {
        this.command = string;
    }

    public void setListener(ActionListener listener) {
        this.listener = listener;
    }
}

