/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.ui;

import com.sap.sdt.engine.core.admin.SDTGuiAdminIF;
import com.sap.sdt.engine.core.communication.Configuration;
import com.sap.sdt.engine.core.communication.Service;
import com.sap.sdt.engine.core.communication.ServiceException;
import com.sap.sdt.engine.core.services.GuiServiceException;
import com.sap.sdt.engine.core.services.GuiServiceIF;
import com.sap.sdt.engine.core.services.ServiceKey;
import com.sap.sdt.gui.core.resources.ResourceConstants;
import com.sap.sdt.gui.core.resources.ResourceManager;
import com.sap.sdt.gui.core.swing.ui.AbstractGui;
import com.sap.sdt.gui.core.swing.ui.GuiConnectDialog;
import com.sap.sdt.gui.core.swing.ui.GuiServiceMenuItem;
import java.awt.event.ActionEvent;

public class Gui
extends AbstractGui
implements ResourceConstants {
    private static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/core/swing/ui/Gui.java#2 $";
    private GuiConnectDialog connectDialog = null;
    int i = 0;

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("CONNECT")) {
            this.connectAction();
        } else if (command.equals("EXIT")) {
            System.exit(0);
        } else if (command.equals("DISCONNECT")) {
            this.disconnectAction();
        } else if (command.equals("NEXT_VIEW")) {
            this.getActivePerspective().getPerspectiveManager().activateNextView();
        } else if (command.equals("PREV_VIEW")) {
            this.getActivePerspective().getPerspectiveManager().activatePreviousView();
        } else {
            GuiServiceMenuItem sI = (GuiServiceMenuItem)event.getSource();
            SDTGuiAdminIF gA = (SDTGuiAdminIF)Configuration.getClientAdmin();
            GuiServiceIF gS = null;
            ServiceKey key = sI.getKey();
            if (gA.hasService(key)) {
                gS = gA.getService(key);
            } else {
                Service s = null;
                try {
                    s = gA.requestService(sI.getInterface(), sI.getID());
                }
                catch (ServiceException sE) {
                    sE.printStackTrace();
                }
                gS = (GuiServiceIF)s.getProvider();
                gA.registerService(key, gS);
                try {
                    gS.addGui(gA.getID());
                }
                catch (GuiServiceException e) {
                    e.printStackTrace();
                }
            }
            this.setPerspective(gS.getPerspective(gA.getID()));
        }
    }

    private void connectAction() {
        if (this.connectDialog == null) {
            this.connectDialog = new GuiConnectDialog(this.frame);
        }
        if (this.connectDialog.showDialog()) {
            try {
                String host = this.connectDialog.getHost();
                int port = this.connectDialog.getPort();
                this.setStatus(ResourceManager.getString("Message.Connecting"));
                Configuration.getClientAdmin().connect(host, port);
                this.setConnected();
            }
            catch (Exception e) {
                this.setStatus(ResourceManager.getString("Message.Disconnected"));
                e.printStackTrace();
            }
        }
    }

    private void disconnectAction() {
        try {
            this.setStatus(ResourceManager.getString("Message.Disconnected"));
            this.removeServiceMenu();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

