/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.ui;

import com.sap.sdt.engine.core.controls.SDTGuiIF;
import com.sap.sdt.engine.core.controls.SDTPerspectiveIF;
import com.sap.sdt.engine.core.services.ServiceKey;
import com.sap.sdt.gui.core.images.ImageHolder;
import com.sap.sdt.gui.core.resources.ResourceConstants;
import com.sap.sdt.gui.core.resources.ResourceManager;
import com.sap.sdt.gui.core.settings.GuiSettings;
import com.sap.sdt.gui.core.swing.controls.GuiMenu;
import com.sap.sdt.gui.core.swing.controls.GuiPerspective;
import com.sap.sdt.gui.core.swing.help.GuiHelp;
import com.sap.sdt.gui.core.swing.ui.GuiAction;
import com.sap.sdt.gui.core.swing.ui.GuiConstants;
import com.sap.sdt.gui.core.swing.ui.GuiFrame;
import com.sap.sdt.gui.core.swing.ui.GuiMenuBar;
import com.sap.sdt.gui.core.swing.ui.GuiServiceMenuItem;
import com.sap.sdt.gui.core.swing.util.SwingToolkit;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.border.Border;

public abstract class AbstractGui
implements SDTGuiIF,
ActionListener,
GuiConstants,
ResourceConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/core/swing/ui/AbstractGui.java#2 $";
    protected JLabel lbStatus = null;
    protected JFrame frame = null;
    protected JMenu serviceMenu = null;
    protected JPanel viewPanel = null;
    protected GuiMenuBar menuBar = null;
    protected SDTPerspectiveIF activePerspective;

    protected AbstractGui() {
        this.init();
    }

    public void addService(ServiceKey key) {
        GuiServiceMenuItem service = new GuiServiceMenuItem(key);
        service.addActionListener(this);
        service.setActionCommand(key.getName());
        this.getMenuBar().getMenuPerspective().add(service);
        this.frame.validate();
    }

    public void setConnected() {
        this.setStatus(ResourceManager.getString("Message.Connected"));
        this.menuBar.getMenuPerspective().setEnabled(true);
    }

    public void setTitle(String title) {
        this.frame.setTitle(title);
    }

    public void setStatus(String status) {
        this.lbStatus.setText(SwingToolkit.getPlainText(status));
        this.lbStatus.setToolTipText(status);
    }

    public void setPerspective(SDTPerspectiveIF perspective) {
        perspective.setParent(this);
        this.showPanel((JPanel)((GuiPerspective)perspective).getPeer());
        List menus = perspective.getMenus();
        if (menus != null) {
            Iterator iter = menus.iterator();
            while (iter.hasNext()) {
                GuiMenu menu = (GuiMenu)iter.next();
                this.menuBar.add(menu.getPeer());
                this.setActionListener((JMenu)menu.getPeer());
            }
        }
        this.setActivePerspective(perspective);
        this.frame.validate();
    }

    private void setActionListener(JMenu menu) {
        for (int i = 0; i < menu.getMenuComponentCount(); ++i) {
            Component comp = menu.getMenuComponent(i);
            if (comp instanceof JMenuItem) {
                ((GuiAction)((JMenuItem)comp).getAction()).setListener(this);
                continue;
            }
            if (!(comp instanceof JMenu)) continue;
            this.setActionListener((JMenu)comp);
        }
    }

    public void show() {
        if (!this.frame.isShowing()) {
            this.frame.setState(1);
            this.frame.setVisible(true);
            this.frame.setState(0);
        } else {
            this.frame.setVisible(true);
        }
        this.frame.invalidate();
        this.frame.validate();
        this.frame.repaint();
    }

    public void hide() {
        this.frame.setVisible(false);
    }

    public JFrame getPeer() {
        return this.frame;
    }

    private void init() {
        this.frame = new GuiFrame(ResourceManager.getString("Gui.Title"));
        this.frame.setIconImage(ImageHolder.SDT_ICON.getImage());
        this.frame.getAccessibleContext().setAccessibleDescription(ResourceManager.getString("Gui.AccessibleDescrition"));
        Container contentPane = this.frame.getContentPane();
        contentPane.setLayout(new BorderLayout(0, 0));
        this.viewPanel = new JPanel();
        contentPane.add((Component)this.viewPanel, "Center");
        this.viewPanel.requestFocus();
        JPanel pnStatus = new JPanel();
        pnStatus.setLayout(new BoxLayout(pnStatus, 0));
        this.lbStatus = new JLabel("Ready");
        this.lbStatus.setFont(GuiSettings.getInstance().getFont("status.text"));
        this.lbStatus.setHorizontalAlignment(2);
        Color c = pnStatus.getBackground();
        Border bevelBorder = BorderFactory.createBevelBorder(1, c.brighter(), c, c.darker(), c);
        Border emptyBorder = BorderFactory.createEmptyBorder(0, 2, 0, 2);
        this.lbStatus.setBorder(BorderFactory.createCompoundBorder(bevelBorder, emptyBorder));
        SwingToolkit.setPrefWidth(this.lbStatus, Short.MAX_VALUE);
        pnStatus.add(this.lbStatus);
        SwingToolkit.setHeight(this.lbStatus, this.lbStatus.getPreferredSize().height + 4);
        this.lbStatus.setText("");
        contentPane.add((Component)pnStatus, "South");
        this.frame.setSize(750, 675);
        SwingToolkit.setLocationRelativeTo(this.frame, null);
        GuiHelp.getInstance().setDisplay(this.frame);
    }

    private void initMenuBar(JFrame frame) {
        this.menuBar = new GuiMenuBar(this);
        frame.setJMenuBar(this.menuBar);
    }

    protected void showPanel(JPanel panel) {
        this.frame.getContentPane().remove(this.viewPanel);
        this.viewPanel = panel;
        this.frame.getContentPane().add((Component)this.viewPanel, "Center");
        this.frame.validate();
        this.frame.repaint();
        this.viewPanel.requestFocus();
    }

    protected void removeServiceMenu() {
        if (this.serviceMenu != null) {
            this.frame.getJMenuBar().remove(this.serviceMenu);
            this.serviceMenu = null;
        }
    }

    public GuiMenuBar getMenuBar() {
        return this.menuBar;
    }

    public void setMenuBar(GuiMenuBar bar) {
        this.menuBar = bar;
        this.frame.setJMenuBar(this.menuBar);
    }

    public SDTPerspectiveIF getActivePerspective() {
        return this.activePerspective;
    }

    public void setActivePerspective(SDTPerspectiveIF perspectiveIF) {
        if (this.activePerspective != null) {
            this.activePerspective.deactivate();
        }
        this.activePerspective = perspectiveIF;
        this.activePerspective.activate();
    }
}

