/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.help;

import com.sap.sdt.gui.core.settings.GuiSettings;
import com.sap.sdt.gui.core.swing.controls.GuiScrollableStyledText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class GuiHelpWindow
extends JDialog {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/core/swing/help/GuiHelpWindow.java#2 $";
    private GuiScrollableStyledText help_text;
    private Dimension m_minSize = null;

    public GuiHelpWindow(JFrame parent) {
        super((Frame)parent, false);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBackground(UIManager.getColor("info"));
        panel.setBorder(BorderFactory.createEmptyBorder(GuiSettings.getInstance().getInt("netweaver.content.space.top"), GuiSettings.getInstance().getInt("netweaver.content.space.side"), GuiSettings.getInstance().getInt("netweaver.content.space.bottom"), GuiSettings.getInstance().getInt("netweaver.content.space.side")));
        this.help_text = new GuiScrollableStyledText();
        this.help_text.setSelectable(false);
        panel.add((Component)this.help_text.getPeer(), "Center");
        this.setContentPane(this.help_text.getPeer());
        Dimension minSize = new Dimension(300, 200);
        GuiHelpWindow.setDefaultLookAndFeelDecorated(true);
        this.setMinimumSize(minSize);
        this.setSize(minSize);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    GuiHelpWindow.this.setVisible(false);
                }
            }
        });
    }

    public void setText(String text) {
        this.help_text.setText(text);
        this.getAccessibleContext().setAccessibleDescription(text);
    }

    public Dimension getMinimumSize() {
        if (this.m_minSize != null) {
            return this.m_minSize;
        }
        return super.getMinimumSize();
    }

    public void setMinimumSize(Dimension minSize) {
        this.m_minSize = minSize;
    }
}

