/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.help;

import com.sap.sdt.engine.core.controls.SDTControlIF;
import com.sap.sdt.engine.core.controls.SDTInternalListenerIF;
import com.sap.sdt.engine.core.event.SDTInternalEvent;
import com.sap.sdt.engine.core.help.SDTHelpCapableIF;
import com.sap.sdt.gui.core.help.HelpEvent;
import com.sap.sdt.gui.core.help.HelpListener;
import com.sap.sdt.gui.core.swing.controls.GuiControl;
import com.sap.sdt.gui.core.swing.help.GuiHelpWindow;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class GuiHelp
implements HelpListener {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/core/swing/help/GuiHelp.java#3 $";
    private static GuiHelp instance;
    private SDTInternalListenerIF resolver = null;
    private SDTControlIF eS = null;
    private GuiHelpWindow helpWindow = null;
    private JFrame display;

    private GuiHelp() {
    }

    public static GuiHelp getInstance() {
        if (instance == null) {
            instance = new GuiHelp();
        }
        return instance;
    }

    public void setText(String text) {
        if (this.helpWindow == null) {
            this.helpWindow = new GuiHelpWindow(this.getDisplay());
            this.helpWindow.setLocation(this.calculateLocation());
        }
        if ((text = text != null ? this.eS.getAdditionalHelpText() + text : this.eS.getAdditionalHelpText()) == null || text.trim().length() == 0) {
            text = "No help available .";
        }
        this.helpWindow.setText(text);
        this.helpWindow.show();
    }

    public void helpRequested(HelpEvent event) {
        SDTHelpCapableIF source = event.getHelpSource();
        String helpItemID = source.getHelpItemID();
        if (helpItemID != null && helpItemID.length() > 0) {
            this.resolveHelpItemID(source, helpItemID);
        } else {
            this.eS = (SDTControlIF)source;
            this.setText(source.getHelp());
        }
        final Component comp = this.getDisplay().getFocusOwner();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GuiHelp.this.getDisplay().requestFocus();
                comp.requestFocusInWindow();
            }
        });
    }

    public synchronized void resolveHelpItemID(SDTHelpCapableIF source, String helpItemID) {
        if (source != null) {
            this.eS = (SDTControlIF)source;
            this.resolver = source.getResolver();
        }
        SDTInternalEvent iE = new SDTInternalEvent(this.eS, "resolveItem", helpItemID);
        this.resolver.eventPerformed(iE);
    }

    public static void setHelp(SDTHelpCapableIF source) {
        ((GuiControl)source).addHelpListener(GuiHelp.getInstance());
    }

    public JFrame getDisplay() {
        return this.display;
    }

    public void setDisplay(JFrame frame) {
        this.display = frame;
    }

    public void hideHelp() {
        if (this.helpWindow != null) {
            this.helpWindow.setVisible(false);
        }
    }

    private Point calculateLocation() {
        if (this.display != null) {
            Point point = this.display.getLocation();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension helpWindowSise = this.helpWindow.getSize();
            Dimension displaySize = this.display.getSize();
            Point pL = this.display.getLocationOnScreen();
            int shift = pL.x + this.display.getSize().width + helpWindowSise.width + 10 - screenSize.width;
            if (shift > 0) {
                point.translate(displaySize.width - shift, displaySize.height / 4);
            } else {
                point.translate(displaySize.width, displaySize.height / 4);
            }
            return point;
        }
        return new Point();
    }
}

