/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.controls.table.renderers;

import com.sap.sdt.gui.core.settings.GuiSettings;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;

public class TreeTableCellRenderer
extends JTree
implements TableCellRenderer {
    private int visibleRow;
    private JTable table;

    public TreeTableCellRenderer(TreeModel model, DefaultTreeCellRenderer renderer) {
        super(model);
        this.setCellRenderer(renderer);
    }

    public void setRowHeight(int rowHeight) {
        if (rowHeight > 0) {
            super.setRowHeight(rowHeight);
            if (this.table != null && this.table.getRowHeight() != rowHeight) {
                this.table.setRowHeight(this.getRowHeight());
            }
        }
    }

    public void setBounds(int x, int y, int w, int h) {
        if (this.table != null) {
            super.setBounds(x, 0, w, this.table.getHeight());
        }
    }

    public void paint(Graphics g) {
        g.translate(0, -this.visibleRow * this.getRowHeight());
        super.paint(g);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.table = table;
        if (isSelected) {
            this.setForeground(table.getForeground());
            this.setBackground(UIManager.getColor("textSelectedOutputBackground"));
        } else {
            this.setForeground(table.getForeground());
            this.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
        }
        this.visibleRow = row;
        this.setFont(GuiSettings.getInstance().getFont("input"));
        return this;
    }

    protected int getMargin() {
        Insets insets = GuiSettings.getInstance().getBorder("cell.nofocus.border").getBorderInsets(null);
        return insets.left + insets.right + 10;
    }
}

