/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.controls.table.renderers;

import com.sap.sdt.gui.core.settings.GuiSettings;
import com.sap.sdt.gui.core.swing.controls.table.renderers.CellRenderer;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.UIManager;

public class ComboBoxCellRenderer
extends CellRenderer {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/core/swing/controls/table/renderers/ComboBoxCellRenderer.java#3 $";
    private final JComboBox co = new JComboBox();

    public ComboBoxCellRenderer() {
        this.co.setOpaque(true);
        this.co.setEditable(true);
        this.co.setBorder(null);
        this.co.setFont(GuiSettings.getInstance().getFont("input"));
    }

    public int getPreferredHeight() {
        return this.co.getPreferredSize().height;
    }

    public int getPreferredWidth() {
        return this.co.getPreferredSize().width + super.getMargin();
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.configureRendererComponent(this.co, table, value, isSelected, hasFocus, row, column);
        this.co.removeAllItems();
        this.co.addItem(value);
        this.co.setSelectedItem(value);
        if (table.isCellEditable(row, column)) {
            if (isSelected) {
                if (table.isEditing()) {
                    if (table.getEditingColumn() == column && table.getEditingRow() == row) {
                        this.co.getEditor().getEditorComponent().setForeground(new Color(table.getSelectionForeground().getRGB()));
                        this.co.getEditor().getEditorComponent().setBackground(new Color(table.getSelectionBackground().getRGB()));
                    }
                } else {
                    this.co.getEditor().getEditorComponent().setForeground(new Color(table.getSelectionForeground().getRGB()));
                    this.co.getEditor().getEditorComponent().setBackground(new Color(table.getSelectionBackground().getRGB()));
                }
            } else {
                this.co.getEditor().getEditorComponent().setBackground(new Color(table.getBackground().getRGB()));
                this.co.getEditor().getEditorComponent().setForeground(new Color(table.getForeground().getRGB()));
            }
        } else if (isSelected) {
            this.co.getEditor().getEditorComponent().setBackground(new Color(UIManager.getColor("textSelectedOutputBackground").getRGB()));
        } else {
            this.co.getEditor().getEditorComponent().setBackground(new Color(UIManager.getColor("ComboBox.disabledBackground").getRGB()));
        }
        this.co.setToolTipText((String)value);
        return this.co;
    }

    public int getAlignment() {
        return 2;
    }

    public void setAlignment(int alignment) {
    }
}

