/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.controls.table.renderers;

import com.sap.sdt.gui.core.settings.GuiSettings;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;

public abstract class CellRenderer
implements TableCellRenderer {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/core/swing/controls/table/renderers/CellRenderer.java#3 $";

    public abstract int getPreferredHeight();

    public abstract int getPreferredWidth();

    public abstract int getAlignment();

    public abstract void setAlignment(int var1);

    protected int getMargin() {
        Insets insets = GuiSettings.getInstance().getBorder("cell.nofocus.border").getBorderInsets(null);
        return insets.left + insets.right + 10;
    }

    public void configureRendererComponent(JComponent comp, JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (hasFocus) {
            table.putClientProperty("FOCUSED_COLUMN", new Integer(column));
        }
        if (hasFocus && !isSelected) {
            table.changeSelection(row, column, false, false);
        }
        if (table.isCellEditable(row, column)) {
            if (isSelected) {
                if (table.isEditing()) {
                    if (table.getEditingColumn() == column && table.getEditingRow() == row) {
                        comp.setForeground(table.getSelectionForeground());
                        comp.setBackground(table.getSelectionBackground());
                    } else {
                        comp.setForeground(table.getForeground());
                        comp.setBackground(table.getBackground());
                    }
                } else {
                    comp.setForeground(table.getSelectionForeground());
                    comp.setBackground(table.getSelectionBackground());
                }
            } else {
                comp.setForeground(table.getForeground());
                comp.setBackground(table.getBackground());
            }
        } else if (isSelected) {
            comp.setForeground(table.getForeground());
            comp.setBackground(UIManager.getColor("textSelectedOutputBackground"));
        } else {
            comp.setForeground(table.getForeground());
            comp.setBackground(table.getBackground());
        }
        if (hasFocus) {
            if (table.isEditing()) {
                if (table.getEditingColumn() == column && table.getEditingRow() == row) {
                    comp.setBorder(GuiSettings.getInstance().getBorder("cell.focus.border"));
                } else {
                    comp.setBorder(GuiSettings.getInstance().getBorder("cell.nofocus.border"));
                }
            } else {
                comp.setBorder(GuiSettings.getInstance().getBorder("cell.focus.border"));
            }
        } else {
            comp.setBorder(GuiSettings.getInstance().getBorder("cell.nofocus.border"));
        }
    }
}

