/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.controls.table.editors;

import com.sap.sdt.gui.core.resources.ResourceConstants;
import com.sap.sdt.gui.core.settings.GuiSettings;
import com.sap.sdt.gui.core.swing.util.ValidateDocument;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class TextCellEditor
extends DefaultCellEditor
implements ResourceConstants,
ActionListener {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/core/swing/controls/table/editors/TextCellEditor.java#4 $";
    private static final String CMD = "check";
    private JTextField ftf = (JTextField)this.getComponent();
    private int minLength = 0;
    private boolean isNumeric = false;
    private JTable table;

    public TextCellEditor() {
        super(new JTextField());
        this.ftf.setDocument(new ValidateDocument());
        this.ftf.getInputMap().put(KeyStroke.getKeyStroke(10, 0), CMD);
        this.ftf.addActionListener(this);
        this.ftf.setActionCommand(CMD);
        this.ftf.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                TextCellEditor.this.stopCellEditing();
            }
        });
        this.ftf.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 112) {
                    KeyListener[] keyL = TextCellEditor.this.table.getKeyListeners();
                    for (int i = 0; i < keyL.length; ++i) {
                        keyL[i].keyPressed(e);
                    }
                }
            }
        });
        if (this.isNumeric) {
            this.ftf.setHorizontalAlignment(4);
        }
        this.ftf.setFont(GuiSettings.getInstance().getFont("input"));
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.table = table;
        this.ftf = (JTextField)super.getTableCellEditorComponent(table, value, isSelected, row, column);
        if (this.isNumeric) {
            this.ftf.setHorizontalAlignment(4);
        }
        return this.ftf;
    }

    public Object getCellEditorValue() {
        JTextField ftf = (JTextField)this.getComponent();
        return ftf.getText();
    }

    public void setMaxLength(int i) {
        ((ValidateDocument)this.ftf.getDocument()).setMaxLength(i);
    }

    public void setUpper(boolean b) {
        ((ValidateDocument)this.ftf.getDocument()).setUpperCase(b);
    }

    public boolean stopCellEditing() {
        return super.stopCellEditing();
    }

    public void actionPerformed(ActionEvent e) {
        JTextField ftf = (JTextField)this.getComponent();
        ftf.postActionEvent();
    }

    public boolean isNumeric() {
        return this.isNumeric;
    }

    public void setNumeric(boolean b) {
        this.isNumeric = b;
    }
}

