/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.controls.table.editors;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellEditor;

public class RadioButtonCellEditor
extends DefaultCellEditor
implements TableCellEditor {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/core/swing/controls/table/editors/RadioButtonCellEditor.java#2 $";
    private JRadioButton rb = new JRadioButton();
    private JTable table;
    private boolean isRadioBox = true;

    public RadioButtonCellEditor() {
        super(new JCheckBox());
        this.rb.setHorizontalAlignment(0);
        this.rb.setOpaque(true);
        this.rb.setHorizontalAlignment(0);
        this.rb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RadioButtonCellEditor.this.stopCellEditing();
            }
        });
        this.rb.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                RadioButtonCellEditor.this.stopCellEditing();
            }
        });
        if (this.isRadioBox) {
            this.rb.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    JRadioButton editor = (JRadioButton)RadioButtonCellEditor.this.table.getEditorComponent();
                    if (editor != null) {
                        editor.setSelected(true);
                    }
                }
            });
        }
    }

    public Object getCellEditorValue() {
        return this.rb.isSelected();
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.table = table;
        if (this.isRadioBox()) {
            for (int i = 0; i < table.getRowCount(); ++i) {
                Boolean b = (Boolean)table.getValueAt(i, column);
                if (b == null || i == row || !b.booleanValue()) continue;
                table.setValueAt(new Boolean(false), i, column);
            }
        }
        this.setValue(value);
        this.rb.setForeground(table.getSelectionForeground());
        this.rb.setBackground(table.getSelectionBackground());
        return this.rb;
    }

    public void setValue(Object value) {
        boolean selected = false;
        if (value instanceof Boolean) {
            selected = (Boolean)value;
        } else if (value instanceof String) {
            selected = value.equals("true");
        }
        this.rb.setSelected(selected);
    }

    public boolean isRadioBox() {
        return this.isRadioBox;
    }

    public void setRadioBox(boolean b) {
        this.isRadioBox = b;
    }
}

