/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.controls.table.editors;

import com.sap.sdt.gui.core.resources.ResourceConstants;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.NumberFormat;
import javax.swing.AbstractCellEditor;
import javax.swing.JFormattedTextField;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellEditor;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class IntegerCellEditor
extends AbstractCellEditor
implements TableCellEditor,
ResourceConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/core/swing/controls/table/editors/IntegerCellEditor.java#2 $";
    private static final String CMD = "check";
    private JFormattedTextField component;
    private NumberFormat integerFormat;
    private Integer minimum;
    private Integer maximum;
    private JTable table;

    public IntegerCellEditor(int min, int max) {
        JFormattedTextField ftf = new JFormattedTextField();
        ftf.setHorizontalAlignment(4);
        ftf.setHorizontalAlignment(4);
        this.minimum = new Integer(min);
        this.maximum = new Integer(max);
        this.integerFormat = NumberFormat.getIntegerInstance();
        NumberFormatter intFormatter = new NumberFormatter(this.integerFormat);
        intFormatter.setAllowsInvalid(false);
        ftf.setFocusLostBehavior(0);
        intFormatter.setFormat(this.integerFormat);
        intFormatter.setMinimum(this.minimum);
        intFormatter.setMaximum(this.maximum);
        ftf.setFormatterFactory(new DefaultFormatterFactory(intFormatter));
        ftf.setValue(this.minimum);
        ftf.getInputMap().put(KeyStroke.getKeyStroke(10, 0), CMD);
        ftf.setActionCommand(CMD);
        ftf.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                IntegerCellEditor.this.stopCellEditing();
            }
        });
        ftf.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 112) {
                    KeyListener[] keyL = IntegerCellEditor.this.table.getKeyListeners();
                    for (int i = 0; i < keyL.length; ++i) {
                        keyL[i].keyPressed(e);
                    }
                }
            }
        });
        this.component = ftf;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.table = table;
        this.component.setValue(value);
        return this.component;
    }

    public Object getCellEditorValue() {
        return this.component.getValue();
    }
}

