/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.controls.table.editors;

import com.sap.sdt.gui.core.settings.GuiSettings;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;

public class ComboBoxCellEditor
extends DefaultCellEditor {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/core/swing/controls/table/editors/ComboBoxCellEditor.java#2 $";
    private JComboBox editorComponent = (JComboBox)super.getComponent();
    private JTable table;

    public ComboBoxCellEditor() {
        super(new JComboBox());
        this.editorComponent.setEditable(false);
        this.editorComponent.putClientProperty("ComboBox.calculateMaxStringLength", Boolean.TRUE);
        this.editorComponent.setFont(GuiSettings.getInstance().getFont("input"));
        this.editorComponent.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                ComboBoxCellEditor.this.stopCellEditing();
            }
        });
        this.editorComponent.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 112) {
                    KeyListener[] keyL = ComboBoxCellEditor.this.table.getKeyListeners();
                    for (int i = 0; i < keyL.length; ++i) {
                        keyL[i].keyPressed(e);
                    }
                }
            }
        });
    }

    public void setValues(List values) {
        if (values == null) {
            return;
        }
        for (int i = 0; i < values.size(); ++i) {
            this.editorComponent.addItem(values.get(i));
        }
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.table = table;
        this.editorComponent.setSelectedItem(value);
        table.putClientProperty("FOCUSED_COLUMN", new Integer(column));
        return this.editorComponent;
    }
}

