/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.controls.table;

import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;

public class GuiTreeTableSelection
extends DefaultTreeSelectionModel {
    protected boolean updatingListSelectionModel;
    private JTree tree;

    public GuiTreeTableSelection(JTree tree, boolean multipleSelectionAllowed) {
        this.tree = tree;
        this.setSelectionMode(4);
        this.listSelectionModel.setSelectionMode(multipleSelectionAllowed ? 2 : 0);
        this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
    }

    public ListSelectionModel getListSelectionModel() {
        return this.listSelectionModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetRowSelection() {
        if (!this.updatingListSelectionModel) {
            this.updatingListSelectionModel = true;
            try {
                super.resetRowSelection();
            }
            finally {
                this.updatingListSelectionModel = false;
            }
        }
    }

    protected ListSelectionListener createListSelectionListener() {
        return new ListSelectionHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSelectedPathsFromSelectedRows() {
        if (!this.updatingListSelectionModel) {
            this.updatingListSelectionModel = true;
            try {
                int min = this.listSelectionModel.getMinSelectionIndex();
                int max = this.listSelectionModel.getMaxSelectionIndex();
                this.clearSelection();
                if (min != -1 && max != -1) {
                    for (int counter = min; counter <= max; ++counter) {
                        TreePath selPath;
                        if (!this.listSelectionModel.isSelectedIndex(counter) || (selPath = this.tree.getPathForRow(counter)) == null) continue;
                        this.addSelectionPath(selPath);
                    }
                }
            }
            finally {
                this.updatingListSelectionModel = false;
            }
        }
    }

    class ListSelectionHandler
    implements ListSelectionListener {
        ListSelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent e) {
            GuiTreeTableSelection.this.updateSelectedPathsFromSelectedRows();
        }
    }
}

