/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.controls.table;

import com.sap.sdt.engine.core.controls.table.SDTTreeTableNode;
import com.sap.sdt.gui.core.swing.controls.table.GuiTreeTableNode;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class GuiTreeTableModel
extends AbstractTableModel {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/core/swing/controls/table/GuiTreeTableModel.java#2 $";
    private List columnNames = new ArrayList();
    private List columnClasses = new ArrayList();
    private JTree tree;

    public int getChildCount(Object node) {
        List children = this.getChildren(node);
        return children == null ? 0 : children.size();
    }

    public Object getChild(Object node, int i) {
        return this.getChildren(node).get(i);
    }

    public int getColumnCount() {
        return this.columnNames.size();
    }

    public String getColumnName(int column) {
        return (String)this.columnNames.get(column);
    }

    public Class getColumnClass(int column) {
        JTable t = new JTable();
        return (Class)this.columnClasses.get(column);
    }

    public void addColumn(String name, int type) {
        this.columnNames.add(name);
        if (type == 5) {
            this.columnClasses.add(GuiTreeTableModel.class);
        } else {
            this.columnClasses.add(String.class);
        }
        this.fireTableStructureChanged();
    }

    public void addColumn(String name) {
        this.addColumn(name, 0);
    }

    public int getRowCount() {
        if (this.tree == null) {
            return 0;
        }
        return this.tree.getRowCount();
    }

    public void setTree(JTree tree) {
        this.tree = tree;
        tree.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                GuiTreeTableModel.this.fireTableDataChanged();
            }

            public void treeCollapsed(TreeExpansionEvent event) {
                GuiTreeTableModel.this.fireTableDataChanged();
            }
        });
        this.fireTableDataChanged();
    }

    public void setData(DefaultTreeModel model) {
        this.tree.setModel(model);
        this.fireTableDataChanged();
    }

    protected Object nodeForRow(int row) {
        TreePath treePath = this.tree.getPathForRow(row);
        return treePath.getLastPathComponent();
    }

    public Object getValueAt(int row, int column) {
        TreePath treePath = this.tree.getPathForRow(row);
        GuiTreeTableNode node = (GuiTreeTableNode)treePath.getLastPathComponent();
        SDTTreeTableNode data = node.getData();
        return data.getData().getCells().get(column);
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.getColumnClass(columnIndex) == GuiTreeTableModel.class;
    }

    private List getChildren(Object node) {
        SDTTreeTableNode sduNode = (SDTTreeTableNode)node;
        return sduNode.getChildren();
    }
}

