/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.controls.table;

import com.sap.sdt.engine.core.controls.table.SDTTableColumn;
import com.sap.sdt.gui.core.swing.controls.GuiOutlineTable;
import com.sap.sdt.gui.core.swing.controls.table.AbstractModifier;
import com.sap.sdt.gui.core.swing.controls.table.ModifierFactory;
import com.sap.sdt.gui.core.swing.controls.table.ModifyEvent;
import com.sap.sdt.gui.core.swing.controls.table.ModifyListener;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class GuiTableEditor
extends JPanel
implements ActionListener,
FocusListener,
ModifyListener {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/core/swing/controls/table/GuiTableEditor.java#2 $";
    private ArrayList model = new ArrayList();
    private JButton addButton;
    private JButton removeButton;
    private GuiOutlineTable table;
    private JPanel editPanel;
    private JPanel buttonPanel;
    private JButton showButton;

    public GuiTableEditor(GuiOutlineTable table) {
        this.table = table;
        this.setLayout(new GridBagLayout());
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridBagLayout());
        this.addButton = new JButton("Add");
        this.addButton.addActionListener(this);
        this.addButton.setActionCommand("ADD_CMD");
        this.buttonPanel.add((Component)this.addButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.removeButton = new JButton("Remove");
        this.removeButton.addActionListener(this);
        this.removeButton.setActionCommand("REMOVE_CMD");
        this.buttonPanel.add((Component)this.removeButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.editPanel = new JPanel();
        this.editPanel.setLayout(new GridBagLayout());
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        JLabel title = new JLabel("Table Editor");
        toolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        toolBar.setBorderPainted(false);
        toolBar.setLayout(new GridBagLayout());
        toolBar.add((Component)title, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 13, 2, new Insets(0, 5, 5, 0), 0, 0));
        this.showButton = new JButton("Hide");
        this.showButton.addActionListener(this);
        this.showButton.putClientProperty("buttontype", "AppToolbar");
        toolBar.putClientProperty("toolbarType", new Integer(4));
        toolBar.add((Component)this.showButton, new GridBagConstraints(3, 0, 3, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)toolBar, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.editPanel, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.buttonPanel, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.addFocusListener(this);
        this.setBorder(BorderFactory.createLoweredBevelBorder());
    }

    public void addElement(SDTTableColumn column) {
        int pos = this.model.size();
        JLabel label = new JLabel(column.getCaption());
        this.editPanel.add((Component)label, new GridBagConstraints(0, pos, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        AbstractModifier modifier = ModifierFactory.createModifier(column.getColumnType());
        if (column.getValues() != null) {
            modifier.setInitialValues(column.getValues().toArray());
        }
        this.editPanel.add(modifier.getComponent(), new GridBagConstraints(1, pos, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        label.setLabelFor(modifier.getComponent());
        int type = column.getColumnType();
        modifier.addModifierChangeListener(this);
        this.model.add(modifier);
    }

    public void setData(ArrayList data) {
        for (int i = 0; i < data.size(); ++i) {
            ((AbstractModifier)this.model.get(i)).setValue(data.get(i));
        }
    }

    public ArrayList getData() {
        ArrayList<Object> data = new ArrayList<Object>();
        for (int i = 0; i < this.model.size(); ++i) {
            data.add(((AbstractModifier)this.model.get(i)).getValue());
        }
        return data;
    }

    public int getType(int index) {
        return (Integer)this.model.get(index);
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("ADD_CMD")) {
            this.table.addRow(this.getData());
        } else if (cmd.equals("REMOVE_CMD")) {
            int[] sel = this.table.getSelectedRows();
            for (int i = sel.length - 1; i >= 0; --i) {
                this.table.removeRow(sel[i]);
            }
        } else {
            JButton o = (JButton)e.getSource();
            if (o.getText().equals("Hide")) {
                this.editPanel.setVisible(false);
                this.buttonPanel.setVisible(false);
                this.getParent().validate();
                this.showButton.setText("Show");
            } else {
                this.editPanel.setVisible(true);
                this.buttonPanel.setVisible(true);
                this.getParent().validate();
                this.showButton.setText("Hide");
            }
        }
    }

    public void focusGained(FocusEvent e) {
        ((AbstractModifier)this.model.get(0)).getComponent().requestFocus();
    }

    public void focusLost(FocusEvent e) {
    }

    public void modifierChanged(ModifyEvent event) {
        int column;
        int[] sel = this.table.getSelectedRows();
        if (sel.length == 1 && (column = this.getColumn(event.getSource())) > -1) {
            this.table.modify(event.getSource().getValue(), sel[0], column);
        }
    }

    private int getColumn(AbstractModifier modifier) {
        return this.model.indexOf(modifier);
    }
}

