/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.controls;

import com.sap.sdt.engine.core.controls.SDTMenuIF;
import com.sap.sdt.engine.core.controls.SDTMenuItemIF;
import com.sap.sdt.engine.core.controls.SDTMessageBoxIF;
import com.sap.sdt.engine.core.controls.SDTPerspectiveIF;
import com.sap.sdt.engine.core.controls.SDTViewIF;
import com.sap.sdt.gui.core.settings.GuiSettings;
import com.sap.sdt.gui.core.swing.controls.AlignableLayout;
import com.sap.sdt.gui.core.swing.controls.GuiContainer;
import com.sap.sdt.gui.core.swing.ui.event.ActivationChangedListener;
import com.sap.sdt.gui.core.swing.ui.event.ActivationEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;

public class GuiView
extends GuiContainer
implements SDTViewIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/core/swing/controls/GuiView.java#2 $";
    protected SDTPerspectiveIF parent = null;
    protected String guiTitle;
    protected String status;
    private Vector activationListeners;

    public GuiView() {
        int hgap = GuiSettings.getInstance().getInt("layout.horizontal.gap");
        int vgap = GuiSettings.getInstance().getInt("layout.vertical.gap");
        this.peer().setLayout(new AlignableLayout(hgap, vgap));
    }

    public void setParent(SDTPerspectiveIF parent) {
        this.parent = parent;
    }

    public SDTPerspectiveIF getParent() {
        return this.parent;
    }

    public void setGuiTitle(String guiTitle) {
        if (this.parent != null) {
            this.getParent().setGuiTitle(this, guiTitle);
        }
        this.guiTitle = guiTitle;
    }

    public String getGuiTitle() {
        return this.guiTitle;
    }

    public void setStatus(String status) {
        if (this.parent != null) {
            this.getParent().setStatus(this, status);
        }
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public void showPopup(SDTMessageBoxIF popup) {
        this.getParent().showPopup(this, popup);
    }

    public void hidePopup() {
        this.getParent().hidePopup(this);
    }

    public void close() {
    }

    public void activate() {
        this.fireActivationChanged(new ActivationEvent(1, this));
    }

    public void deactivate() {
        this.fireActivationChanged(new ActivationEvent(0, this));
    }

    public void addActivationChangedListener(ActivationChangedListener listener) {
        if (this.activationListeners == null) {
            this.activationListeners = new Vector();
        }
        this.activationListeners.addElement(listener);
    }

    public void addMenu(SDTMenuIF menu) {
        if (this.parent != null) {
            this.parent.addMenu(this, menu);
        }
    }

    public void addMenuItem(SDTMenuItemIF menu) {
        if (this.parent != null) {
            this.parent.addMenu(this, menu);
        }
    }

    protected void performMouseClicked(MouseEvent e) {
        super.performMouseClicked(e);
        if (!this.getParent().getPerspectiveManager().isActive(this)) {
            this.getParent().getPerspectiveManager().activate(this);
        }
    }

    private void fireActivationChanged(ActivationEvent e) {
        if (this.activationListeners != null) {
            for (int i = 0; i < this.activationListeners.size(); ++i) {
                ActivationChangedListener next = (ActivationChangedListener)this.activationListeners.elementAt(i);
                next.activationChanged(e);
            }
        }
    }
}

