/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.controls;

import com.sap.sdt.engine.core.controls.SDTTreeTableIF;
import com.sap.sdt.engine.core.controls.table.SDTTableColumn;
import com.sap.sdt.engine.core.controls.table.SDTTableRow;
import com.sap.sdt.engine.core.controls.table.SDTTreeTableNode;
import com.sap.sdt.gui.core.settings.GuiSettings;
import com.sap.sdt.gui.core.swing.controls.GuiComponent;
import com.sap.sdt.gui.core.swing.controls.GuiInlineTable;
import com.sap.sdt.gui.core.swing.controls.table.GuiTreeTableModel;
import com.sap.sdt.gui.core.swing.controls.table.GuiTreeTableNode;
import com.sap.sdt.gui.core.swing.controls.table.GuiTreeTableSelection;
import com.sap.sdt.gui.core.swing.controls.table.Windows14Table;
import com.sap.sdt.gui.core.swing.controls.table.editors.TextCellEditor;
import com.sap.sdt.gui.core.swing.controls.table.editors.TreeTableCellEditor;
import com.sap.sdt.gui.core.swing.controls.table.renderers.TableHeaderRenderer;
import com.sap.sdt.gui.core.swing.controls.table.renderers.TextCellRenderer;
import com.sap.sdt.gui.core.swing.controls.table.renderers.TreeInTableRenderer;
import com.sap.sdt.gui.core.swing.controls.table.renderers.TreeTableCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.tree.DefaultTreeModel;

public class GuiTreeTable
extends GuiComponent
implements SDTTreeTableIF {
    private JTable table;
    private TreeTableCellRenderer tree;
    private DefaultTreeModel treeModel;
    private GuiTreeTableModel tableModel;
    int n = 0;

    GuiTreeTable() {
        super(new JPanel());
        JPanel panel = (JPanel)this.peer;
        panel.setLayout(new BorderLayout(0, 0));
        this.table = new Windows14Table();
        JScrollPane scroll = new JScrollPane();
        scroll.setOpaque(false);
        scroll.setViewportView(this.table);
        scroll.getViewport().setBackground(this.table.getBackground());
        panel.add((Component)scroll, "Center");
        this.initTreeModel();
        this.initTableModel();
        this.initVisualSettings();
    }

    public void setEnabled(boolean isEnabled) {
    }

    public boolean validate() {
        return true;
    }

    public void setData(SDTTreeTableNode data) {
        this.tableModel.setTree(this.tree);
        this.treeModel.setRoot(new GuiTreeTableNode(data));
        this.tableModel.setData(this.treeModel);
    }

    public void addColumn(SDTTableColumn column) {
        this.addColumn(column.getCaption(), column.getColumnType());
    }

    private void initTreeModel() {
        SDTTreeTableNode node = new SDTTreeTableNode();
        GuiTreeTableNode root = new GuiTreeTableNode(node);
        this.treeModel = new DefaultTreeModel(root);
    }

    private void initTableModel() {
        this.tableModel = new GuiTreeTableModel();
        this.table.setModel(this.tableModel);
    }

    private void initVisualSettings() {
        TreeInTableRenderer renderer = new TreeInTableRenderer();
        this.tree = new TreeTableCellRenderer(this.treeModel, renderer);
        this.table.setDefaultRenderer(GuiTreeTableModel.class, this.tree);
        this.table.setDefaultEditor(GuiTreeTableModel.class, new TreeTableCellEditor(this.table, this.tree));
        this.table.setShowGrid(false);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        GuiTreeTableSelection selectionWrapper = new GuiTreeTableSelection(this.tree, false);
        this.tree.setSelectionModel(selectionWrapper);
        this.table.setSelectionModel(selectionWrapper.getListSelectionModel());
    }

    private void addColumn(String name, int type) {
        this.tableModel.addColumn(name, type);
        if (type == 5) {
            this.n = this.table.getColumnCount() - 1;
        }
        this.resetEditorsAndRenderers();
    }

    private void resetEditorsAndRenderers() {
        for (int i = 0; i < this.table.getModel().getColumnCount(); ++i) {
            if (i == this.n) continue;
            this.table.getColumnModel().getColumn(i).setCellEditor(new TextCellEditor());
            this.table.getColumnModel().getColumn(i).setCellRenderer(new TextCellRenderer());
            this.table.getColumnModel().getColumn(i).setHeaderRenderer(new TableHeaderRenderer());
        }
    }

    private static void test_init(SDTTreeTableNode root, int br) {
        SDTTreeTableNode ch = null;
        for (int i = 0; i < br; ++i) {
            ch = new SDTTreeTableNode();
            ArrayList<Object> n = new ArrayList<Object>();
            n.add("child = " + i);
            n.add("Column 1 child = " + i);
            n.add("Column 2 child = " + i);
            n.add(new Boolean("true"));
            SDTTableRow row_n = new SDTTableRow();
            row_n.setCells(n);
            ch.setData(row_n);
            root.addChild(ch);
        }
    }

    public static void test() {
        GuiSettings set = GuiSettings.getInstance();
        JFrame f = new JFrame("Test");
        f.getContentPane().setLayout(new BorderLayout());
        f.setDefaultCloseOperation(3);
        SDTTableRow row = new SDTTableRow();
        ArrayList<Object> l = new ArrayList<Object>(3);
        l.add("Root");
        l.add("Root column 1");
        l.add(new Boolean("true"));
        row.setCells(l);
        SDTTreeTableNode root = new SDTTreeTableNode();
        root.setData(row);
        GuiTreeTable.test_init(root, 5);
        for (int i = 0; i < 5; ++i) {
            SDTTreeTableNode node = (SDTTreeTableNode)root.getChildren().get(i);
            GuiTreeTable.test_init(node, 5);
            GuiTreeTable.test_init((SDTTreeTableNode)node.getChildren().get(0), 3);
        }
        GuiTreeTableNode node = new GuiTreeTableNode(root);
        DefaultTreeModel model = new DefaultTreeModel(node);
        final GuiTreeTable t = new GuiTreeTable();
        SDTTableColumn column = new SDTTableColumn();
        column.setColumnType(5);
        column.setCaption("Tree");
        SDTTableColumn column1 = new SDTTableColumn();
        column1.setColumnType(0);
        column1.setCaption("Column1");
        SDTTableColumn column2 = new SDTTableColumn();
        column2.setColumnType(0);
        column2.setCaption("Column2");
        t.addColumn(column);
        t.addColumn(column1);
        t.addColumn(column2);
        t.setData(root);
        f.getContentPane().add((Component)t.getPeer(), "Center");
        f.getContentPane().add((Component)GuiInlineTable.createTable().getPeer(), "South");
        f.setSize(300, 400);
        f.setVisible(true);
        JButton b = new JButton("Test");
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SDTTableRow row = new SDTTableRow();
                ArrayList<String> l = new ArrayList<String>();
                l.add("Root");
                l.add("Root column 1");
                l.add("Root column 2");
                l.add("Root column 3");
                row.setCells(l);
                SDTTreeTableNode root = new SDTTreeTableNode();
                root.setData(row);
                GuiTreeTable.test_init(root, 2);
                t.setData(root);
            }
        });
        f.getContentPane().add((Component)b, "North");
    }
}

