/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.controls;

import com.sap.sdt.engine.core.controls.SDTTextFieldIF;
import com.sap.sdt.gui.core.settings.GuiSettings;
import com.sap.sdt.gui.core.swing.controls.GuiCaptionComponent;
import com.sap.sdt.gui.core.swing.util.SelectAllFocusListener;
import com.sap.sdt.gui.core.swing.util.SwingToolkit;
import com.sap.sdt.gui.core.swing.util.ValidateDocument;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class GuiTextField
extends GuiCaptionComponent
implements SDTTextFieldIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/core/swing/controls/GuiTextField.java#2 $";
    private final JPanel panel;
    private final JTextField textField;
    private int maxLength = 0;
    private int minLength;
    private int maxValue = Integer.MAX_VALUE;
    private int minValue = Integer.MIN_VALUE;
    private String regexp = null;
    private boolean isNumeric = false;
    private boolean isUpperCase = false;

    public GuiTextField() {
        super(new JPanel());
        this.panel = (JPanel)this.peer;
        this.textField = new JTextField();
        this.createDefaultLayout();
    }

    public void setEnabled(boolean isEnabled) {
        this.textField.setEnabled(isEnabled);
        this.textField.setEditable(isEnabled);
        this.caption.setEnabled(isEnabled);
    }

    public boolean validate() {
        SwingToolkit.removeHighlightBorder(this.textField);
        this.setAdditionalHelpText("");
        boolean isValid = true;
        if (this.regexp != null) {
            isValid = Pattern.matches(this.regexp, this.getText());
        }
        if (this.isNumeric && this.getText().length() != 0) {
            try {
                int number = Integer.parseInt(this.getText());
                if (number < this.minValue) {
                    isValid = false;
                    this.setAdditionalHelpText(this.getAdditionalHelpText() + "Text field '" + this.caption.getText() + "' must contain a number greater or equal than " + this.minValue + ".<p>");
                }
                if (number > this.maxValue) {
                    isValid = false;
                    this.setAdditionalHelpText(this.getAdditionalHelpText() + "Text field '" + this.caption.getText() + "' must contain a number less or equal than " + this.maxValue + ".<p>");
                }
            }
            catch (NumberFormatException ex) {
                isValid = false;
                this.setAdditionalHelpText(this.getAdditionalHelpText() + "Text field '" + this.caption.getText() + "' must contain a number.<p>");
            }
        }
        if (this.minLength != 0 && this.getText().length() < this.minLength) {
            isValid = false;
            this.setAdditionalHelpText(this.getAdditionalHelpText() + "Text field '" + this.caption.getText() + "' must be at least " + this.minLength + " characters long.<p>");
        }
        if (!isValid) {
            SwingToolkit.setHighlightBorder(this.textField);
            if (this.getAdditionalHelpText().trim().length() > 0) {
                this.setAdditionalHelpText("<html><br><strong>Field Limitations</strong><p>" + this.getAdditionalHelpText());
            }
        }
        return isValid;
    }

    private void createDefaultLayout() {
        this.caption.setLabelFor(this.textField);
        this.textField.setDocument(new ValidateDocument());
        this.textField.addKeyListener(this.keyL);
        this.textField.setHorizontalAlignment(2);
        this.textField.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.textField.getPreferredSize().height));
        this.textField.setFont(GuiSettings.getInstance().getFont("input"));
        this.panel.setLayout(new BoxLayout(this.panel, 0));
        this.panel.add(this.caption);
        int hgap = GuiSettings.getInstance().getInt("layout.horizontal.gap");
        this.panel.add(Box.createHorizontalStrut(hgap));
        this.panel.add(this.textField);
        this.panel.putClientProperty("alignable_container", Boolean.TRUE);
        this.panel.putClientProperty("left_component", this.caption);
        this.panel.putClientProperty("right_component", this.textField);
        SelectAllFocusListener.register(this.textField);
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
        if (maxLength != 0) {
            this.textField.setColumns(maxLength);
            Insets insets = this.textField.getInsets();
            int space = insets.left + insets.right + 1;
            space = 0;
            Dimension dim = this.textField.getPreferredSize();
            SwingToolkit.setWidth(this.textField, dim.width + 1);
            ((ValidateDocument)this.textField.getDocument()).setMaxLength(maxLength);
        }
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }

    public void setMinValue(int minValue) {
        this.minValue = minValue;
    }

    public void setRegexp(String regexp) {
        this.regexp = regexp;
    }

    public void setNumeric(boolean isNumeric) {
        this.isNumeric = isNumeric;
    }

    public void setUpperCase(boolean isUpperCase) {
        this.isUpperCase = isUpperCase;
        ((ValidateDocument)this.textField.getDocument()).setUpperCase(isUpperCase);
    }

    public void setText(String text) {
        this.textField.setText(SwingToolkit.getPlainText(text));
        this.textField.revalidate();
        this.textField.repaint();
    }

    public String getText() {
        return this.textField.getText();
    }

    private void selectAll() {
        this.textField.selectAll();
    }
}

