/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.controls;

import com.sap.sdt.engine.core.controls.table.SDTTableRow;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class GuiTableModel
extends AbstractTableModel {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/core/swing/controls/GuiTableModel.java#2 $";
    private List columnNames;
    private List data = new ArrayList();
    private boolean isEditable = true;
    private HashMap editableMap = new HashMap();

    public String getColumnName(int column) {
        return (String)this.columnNames.get(column);
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (!this.isEditable()) {
            return false;
        }
        Boolean mapValue = (Boolean)this.editableMap.get(new Integer(columnIndex));
        if (mapValue == null) {
            return true;
        }
        boolean isEditable = mapValue;
        return isEditable;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (rowIndex < this.data.size()) {
            SDTTableRow row = (SDTTableRow)this.data.get(rowIndex);
            row.getCells().set(columnIndex, aValue);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }

    public int getColumnCount() {
        if (this.columnNames == null) {
            return 0;
        }
        return this.columnNames.size();
    }

    public int getRowCount() {
        return this.data.size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        SDTTableRow row = (SDTTableRow)this.data.get(rowIndex);
        if (row.getCells().size() == 0) {
            for (int i = 0; i < this.columnNames.size(); ++i) {
                row.getCells().add(null);
            }
        }
        return row.getCells().get(columnIndex);
    }

    public void addRow(List row) {
        if (this.data == null) {
            this.data = new ArrayList();
        }
        this.data.add(row);
        this.fireTableRowsInserted(this.data.size(), this.data.size());
    }

    public void addRow(SDTTableRow row) {
        if (this.data == null) {
            this.data = new ArrayList();
        }
        this.data.add(row);
        this.fireTableRowsInserted(this.data.size(), this.data.size());
    }

    public List getColumnNames() {
        if (this.columnNames == null) {
            this.columnNames = new ArrayList();
        }
        return this.columnNames;
    }

    public void setColumnNames(List list) {
        this.columnNames = list;
    }

    public void removeRow(int index) {
        if (this.data.size() > 0 && index < this.data.size()) {
            this.data.remove(index);
            this.fireTableRowsDeleted(index, index);
        }
    }

    public SDTTableRow getRow(int row) {
        return (SDTTableRow)this.data.get(row);
    }

    public List getColumnValues(int column) {
        ArrayList list = new ArrayList();
        for (int i = 0; i < this.getRowCount(); ++i) {
            list.add(((SDTTableRow)this.data.get(i)).getCells().get(column));
        }
        return list;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean b) {
        this.isEditable = b;
    }

    public void setColumnEditable(int column, boolean editable) {
        this.editableMap.put(new Integer(column), new Boolean(editable));
    }
}

