/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.controls;

import com.sap.sdt.engine.core.controls.SDTControlIF;
import com.sap.sdt.engine.core.controls.SDTTabbedPaneIF;
import com.sap.sdt.gui.core.swing.controls.GuiComponent;
import com.sap.sdt.gui.core.swing.controls.GuiControl;
import com.sap.sdt.gui.core.swing.controls.GuiPanel;
import com.sap.sdt.gui.core.swing.controls.GuiView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;

public class GuiTabbedPane
extends GuiComponent
implements SDTTabbedPaneIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/core/swing/controls/GuiTabbedPane.java#2 $";
    private JTabbedPane tabbedpane;

    public GuiTabbedPane() {
        super(new JTabbedPane());
        this.tabbedpane = (JTabbedPane)this.peer;
        this.peer.putClientProperty("resizing", Boolean.TRUE);
    }

    public void setEnabled(boolean isEnabled) {
        for (int i = 0; i < this.tabbedpane.getTabCount(); ++i) {
            this.tabbedpane.setEnabledAt(i, isEnabled);
        }
    }

    public boolean validate() {
        return true;
    }

    public void add(SDTControlIF control, String title) {
        this.tabbedpane.add((Component)((GuiControl)control).getPeer(), title);
    }

    public void setEnabledAt(int index, boolean enabled) {
        this.tabbedpane.setEnabledAt(index, enabled);
    }

    public void setSelectedIndex(int index) {
        this.tabbedpane.setSelectedIndex(index);
    }

    public void setTitleAt(int index, String title) {
        this.tabbedpane.setTitleAt(index, title);
    }

    public void setToolTipAt(int index, String toolTip) {
        this.tabbedpane.setToolTipTextAt(index, toolTip);
    }

    public void add(SDTControlIF child) {
        this.tabbedpane.add(((GuiControl)child).getPeer());
    }

    public void remove(SDTControlIF control) {
        this.tabbedpane.remove(((GuiControl)control).getPeer());
    }

    public void removeAll() {
        this.tabbedpane.removeAll();
    }

    public static void test() {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        final GuiTabbedPane tab = new GuiTabbedPane();
        GuiPanel p = new GuiPanel();
        p.getPeer().add(new JButton("hahah"));
        tab.add(p, "Tab1");
        f.getContentPane().setLayout(new BorderLayout());
        GuiView view = new GuiView();
        view.getPeer().setLayout(new BorderLayout());
        tab.add(view, "Tab2");
        tab.setEnabled(false);
        JButton b = new JButton("test");
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                tab.add(new GuiView(), "Added");
                tab.setEnabledAt(0, false);
            }
        });
        f.getContentPane().add((Component)b, "North");
        f.getContentPane().add((Component)tab.getPeer(), "Center");
        f.setSize(200, 300);
        f.setVisible(true);
    }
}

