/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.controls;

import com.sap.sdt.engine.core.controls.SDTStyledTextIF;
import com.sap.sdt.gui.core.settings.GuiSettings;
import com.sap.sdt.gui.core.swing.controls.GuiComponent;
import com.sap.sdt.gui.core.swing.controls.text.GuiHTMLEditorKit;
import com.sap.sdt.gui.core.swing.help.GuiHelp;
import com.sap.sdt.util.misc.StringHelper;
import java.awt.Color;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.html.HTMLEditorKit;

public class GuiStyledText
extends GuiComponent
implements SDTStyledTextIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/core/swing/controls/GuiStyledText.java#3 $";
    private JEditorPane tx;
    public final HyperlinkListener hyperlinkListener = new OpenBrowserHyperlinkListener();
    private static final HTMLEditorKit htmlKit = new GuiHTMLEditorKit();
    private static JFrame m_fMain;

    public GuiStyledText() {
        super(new JEditorPane());
        this.tx = (JEditorPane)this.peer;
        this.createDefaultLayout();
    }

    private void createDefaultLayout() {
        this.tx.setEditable(false);
        this.tx.setFocusable(false);
        this.tx.setBorder(null);
        this.tx.setOpaque(false);
        this.tx.setEditorKit(htmlKit);
        this.tx.addHyperlinkListener(this.hyperlinkListener);
    }

    public boolean validate() {
        return true;
    }

    public void setText(String text) {
        this.setText(text, false);
    }

    public void setText(String text, boolean bold) {
        if (text == null || text.length() == 0) {
            this.tx.setText("");
            return;
        }
        String htmlText = this.createHTMLText(text, bold);
        this.tx.setText(htmlText);
        this.tx.setCaretPosition(0);
    }

    public void setSelectable(boolean isSelectable) {
        this.tx.setFocusable(isSelectable);
    }

    public void setEnabled(boolean isEnabled) {
    }

    private String createHTMLText(String text, boolean bold) {
        if (!BasicHTML.isHTMLString(text = text.trim())) {
            StringBuffer quotedText = StringHelper.replace(text, '<', "&lt;");
            quotedText = StringHelper.replace(quotedText, '>', "&gt;");
            if (bold) {
                quotedText.insert(0, "<b>");
                quotedText.append("</b>");
            }
            StringBuffer formattedText = StringHelper.replace(quotedText, '\n', "<br>");
            text = "<html>" + quotedText.toString() + "</html>";
        }
        return text;
    }

    private static JPanel createTestPanel() {
        JPanel pn = new JPanel();
        pn.setLayout(new BoxLayout(pn, 1));
        pn.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        Border border = BorderFactory.createLineBorder(Color.red);
        GuiStyledText st = new GuiStyledText();
        st.getPeer().setBorder(border);
        st.setText("Just a few lines of common text plain font...");
        st.setSelectable(true);
        pn.add(new JLabel("Normal Text:"));
        pn.add(st.getPeer());
        st = new GuiStyledText();
        st.getPeer().setBorder(border);
        st.setText("Just a few lines of common text in bold font...", true);
        st.setSelectable(false);
        pn.add(new JLabel("Normal bold Text:"));
        pn.add(st.getPeer());
        st = new GuiStyledText();
        st.getPeer().setBorder(border);
        st.setText("<html>Putting the text in some <b>style rules</b> rocks <font size='+2' color='#0000DD'>all</font> other layouts on your <a href='http://www.sap.com/netweaver'>NetWeaver</a> screen.<html>", true);
        pn.add(new JLabel("Styled Text:"));
        pn.add(st.getPeer());
        pn.add(Box.createVerticalStrut(Short.MAX_VALUE));
        return pn;
    }

    public static void test() {
        JFrame f = new JFrame("Styled Text Test");
        JPanel pn = GuiStyledText.createTestPanel();
        f.setContentPane(pn);
        f.setLocation(300, 100);
        f.setSize(250, 300);
        f.show();
        m_fMain = f;
    }

    public static void main(String[] args) {
        GuiSettings.getInstance();
        GuiStyledText.test();
        m_fMain.setDefaultCloseOperation(3);
    }

    private class OpenBrowserHyperlinkListener
    implements HyperlinkListener {
        private OpenBrowserHyperlinkListener() {
        }

        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String desc = e.getDescription();
                switch (this.extractProtocol(desc)) {
                    case 0: {
                        this.openBrowser(e.getURL().toExternalForm());
                        break;
                    }
                    case 1: {
                        this.resolveHelpItemID(desc);
                        break;
                    }
                }
            }
        }

        private int extractProtocol(String address) {
            if (address.startsWith("http://")) {
                return 0;
            }
            if (address.startsWith("explanation://")) {
                return 1;
            }
            return -1;
        }

        private void openBrowser(String address) {
            if (!GuiSettings.isWindows()) {
                return;
            }
            String[] cmdArray = new String[]{"cmd", "/c start " + address};
            Runtime rt = Runtime.getRuntime();
            try {
                Process p = rt.exec(cmdArray);
            }
            catch (IOException eio) {
                // empty catch block
            }
        }

        private void resolveHelpItemID(String address) {
            GuiHelp.getInstance().resolveHelpItemID(GuiStyledText.this, address.substring(14, address.length()));
        }
    }
}

