/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.controls;

import com.sap.sdt.engine.core.controls.SDTStyledTextIF;
import com.sap.sdt.gui.core.settings.GuiSettings;
import com.sap.sdt.gui.core.swing.controls.GuiComponent;
import com.sap.sdt.gui.core.swing.controls.GuiStyledText;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;

public class GuiScrollableStyledText
extends GuiComponent
implements SDTStyledTextIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/core/swing/controls/GuiScrollableStyledText.java#2 $";
    private static final int MIN_WIDTH = 400;
    private static final int MAX_WIDTH = 600;
    private static final int INCREMENT_WIDTH = 100;
    private static final int RATIO = 15;
    private static final GuiSettings settings = GuiSettings.getInstance();
    private JScrollPane sc;
    private GuiStyledText tx;
    private JTextComponent txPeer;
    private static GuiScrollableStyledText st;
    private static JFrame m_fMain;

    public GuiScrollableStyledText() {
        super(new JScrollPane());
        this.sc = (JScrollPane)this.peer;
        this.createDefaultLayout();
    }

    private void createDefaultLayout() {
        this.tx = new GuiStyledText();
        this.txPeer = (JTextComponent)this.tx.getPeer();
        this.txPeer.setBorder(new BasicBorders.MarginBorder());
        this.txPeer.setMargin(new Insets(settings.getInt("netweaver.form.space.top"), settings.getInt("netweaver.form.space.side"), settings.getInt("netweaver.form.space.bottom"), settings.getInt("netweaver.form.space.side")));
        this.sc.putClientProperty("scrollable_form", Boolean.FALSE);
        this.sc.setFocusable(true);
        this.sc.setViewportView(this.txPeer);
        this.sc.setHorizontalScrollBarPolicy(31);
        this.sc.setVerticalScrollBarPolicy(20);
        this.sc.getVerticalScrollBar().setUnitIncrement(this.sc.getFontMetrics(GuiSettings.getInstance().getFont("text")).getHeight());
        this.sc.setBackground(GuiSettings.getInstance().getBackground("summary"));
    }

    public void setText(String text) {
        this.sc.setViewportView(null);
        this.tx.setText(text);
        Insets margin = this.txPeer.getMargin();
        int xMargin = margin.left + margin.right;
        int yMargin = margin.top + margin.bottom;
        View v = this.txPeer.getUI().getRootView(this.txPeer);
        int width = 300;
        int height = 1;
        boolean nice = false;
        do {
            v.setSize((width += 100) - xMargin, 2.1474836E9f);
            height = (int)v.getPreferredSpan(1) + yMargin;
            if (width * 10 / height <= 15) continue;
            nice = true;
            break;
        } while (width + 100 <= 600);
        if (!nice) {
            height = width * 10 / 15;
        }
        this.txPeer.setPreferredSize(new Dimension(width, height));
        this.sc.setViewportView(this.txPeer);
    }

    public void setText(String text, boolean isBold) {
        this.setText(text);
    }

    public void setSelectable(boolean isSelectable) {
        this.tx.setSelectable(isSelectable);
    }

    public void setEnabled(boolean isEnabled) {
    }

    public boolean validate() {
        return this.tx.validate();
    }

    private static JPanel createTestPanel() {
        JPanel pn = new JPanel();
        pn.setLayout(new BorderLayout());
        pn.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        st = new GuiScrollableStyledText();
        st.setText("<html>Just a few lines <br>of <br>common text in <br>plain font...</html>");
        st.setSelectable(true);
        pn.add(st.getPeer());
        return pn;
    }

    public static void test() {
        JFrame f = new JFrame("Scrollable Styled Text Test");
        JPanel pn = GuiScrollableStyledText.createTestPanel();
        f.setContentPane(pn);
        f.setLocation(300, 100);
        f.setSize(250, 300);
        f.show();
        m_fMain = f;
    }

    public static void main(String[] args) {
        GuiSettings.getInstance();
        GuiScrollableStyledText.test();
        m_fMain.setDefaultCloseOperation(3);
    }
}

