/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.controls;

import com.sap.sdt.engine.core.controls.SDTRoadMapIF;
import com.sap.sdt.gui.core.settings.GuiSettings;
import com.sap.sdt.gui.core.swing.controls.GuiComponent;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class GuiRoadMap
extends GuiComponent
implements SDTRoadMapIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/core/swing/controls/GuiRoadMap.java#2 $";
    private JPanel panel;
    private List steps;

    public GuiRoadMap() {
        super(new JPanel());
        this.panel = (JPanel)this.peer;
        this.createDefaultLayout();
    }

    public void setEnabled(boolean isEnabled) {
    }

    public boolean validate() {
        return true;
    }

    public void addStep(String stepName, int index) {
    }

    public void addStep(String stepName) {
        if (this.steps == null) {
            this.steps = new ArrayList();
        }
        this.panel.add(this.initOneStepControl(stepName));
    }

    public void setActive(int step) {
        ((StepElement)this.steps.get(step)).setActive();
    }

    public void setActive(String stepName) {
        int index = this.getIndex(stepName);
        if (index > -1) {
            this.setActive(index);
        }
    }

    public void setSteps(List steps) {
        for (int i = 0; i < steps.size(); ++i) {
            this.panel.add(this.initOneStepControl((String)steps.get(i)));
        }
    }

    public void createDefaultLayout() {
        this.panel.setLayout(new BoxLayout(this.panel, 0));
    }

    private JPanel initOneStepControl(String stepName) {
        JPanel upPanel = new JPanel();
        upPanel.setLayout(new BoxLayout(upPanel, 0));
        JPanel downPanel = new JPanel();
        downPanel.setLayout(new BoxLayout(downPanel, 0));
        int i = this.steps.size() + 1;
        JButton stepBut = new JButton("  " + i + ".  ");
        stepBut.putClientProperty("buttontype", "AppToolbar");
        Color defForeground = stepBut.getForeground();
        stepBut.setEnabled(false);
        UIManager.put("Button.disabledText", defForeground);
        SwingUtilities.updateComponentTreeUI(stepBut);
        JLabel stepDesciption = new JLabel(stepName);
        StringBuffer buf = new StringBuffer();
        buf.append("-");
        for (int j = 0; j < stepName.length() - 1; ++j) {
            buf.append("-");
        }
        JLabel l = new JLabel(buf.toString());
        JLabel l1 = new JLabel(buf.toString());
        upPanel.add(l);
        upPanel.add(stepBut);
        upPanel.add(l1);
        downPanel.add(stepDesciption);
        JPanel all = new JPanel();
        all.setLayout(new BoxLayout(all, 1));
        all.add(upPanel);
        all.add(downPanel);
        all.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        StepElement stepElement = new StepElement();
        stepElement.setDesciption(stepDesciption);
        stepElement.setStepButton(stepBut);
        this.steps.add(stepElement);
        return all;
    }

    private int getIndex(String stepName) {
        for (int i = 0; i < this.steps.size(); ++i) {
            StepElement el = (StepElement)this.steps.get(i);
            if (!el.getDescription().getText().equals(stepName)) continue;
            return i;
        }
        return -1;
    }

    public static void test() {
        GuiSettings.getInstance();
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        GuiRoadMap c = new GuiRoadMap();
        c.addStep("Select Support Package Type");
        c.addStep("Specify the Queue");
        c.addStep("Check the Queue");
        c.addStep("Deploy the Queue");
        c.addStep("Finished");
        c.setActive(2);
        f.getContentPane().add(c.getPeer());
        f.setSize(400, 500);
        f.setVisible(true);
    }

    private class StepElement {
        private JButton stepButton;
        private JLabel description;

        private StepElement() {
        }

        public void setStepButton(JButton button) {
            this.stepButton = button;
        }

        public void setDesciption(JLabel label) {
            this.description = label;
        }

        public void setActive() {
            Font font = this.description.getFont().deriveFont(1);
            this.description.setFont(font);
            this.stepButton.setFont(this.stepButton.getFont().deriveFont(1));
        }

        public JLabel getDescription() {
            return this.description;
        }

        public JButton getStepButton() {
            return this.stepButton;
        }
    }
}

