/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.controls;

import com.sap.sdt.engine.core.controls.SDTItemListenerIF;
import com.sap.sdt.engine.core.controls.SDTRadioButtonIF;
import com.sap.sdt.gui.core.settings.GuiSettings;
import com.sap.sdt.gui.core.swing.controls.GuiComponent;
import com.sap.sdt.gui.core.swing.controls.GuiItemListener;
import javax.swing.BorderFactory;
import javax.swing.JRadioButton;
import javax.swing.border.Border;

class GuiRadioButton
extends GuiComponent
implements SDTRadioButtonIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/core/swing/controls/GuiRadioButton.java#2 $";
    private JRadioButton button;

    GuiRadioButton() {
        super(new JRadioButton());
        this.button = (JRadioButton)this.peer;
        this.button.addKeyListener(this.keyL);
        this.button.setFont(GuiSettings.getInstance().getFont("label"));
        Border border = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    }

    public void setEnabled(boolean isEnabled) {
        this.button.setEnabled(isEnabled);
    }

    public boolean validate() {
        return true;
    }

    public void setSelected(boolean isSelected) {
        this.button.setSelected(isSelected);
        this.button.requestFocus();
    }

    public boolean isSelected() {
        return this.button.isSelected();
    }

    public void setCaption(String caption, char mnemonic) {
        this.button.setText(caption);
        this.button.setMnemonic(mnemonic);
    }

    public void setMnemonicIndex(int index) {
        this.button.setDisplayedMnemonicIndex(index);
    }

    public void addItemListener(SDTItemListenerIF listener) {
        GuiItemListener gL = (GuiItemListener)listener;
        this.button.addItemListener(gL.peer());
        gL.addSource(this.button, this);
    }

    JRadioButton getButton() {
        return this.button;
    }
}

