/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.controls;

import com.sap.sdt.engine.core.controls.SDTRadioBoxIF;
import com.sap.sdt.engine.core.controls.SDTRadioButtonIF;
import com.sap.sdt.gui.core.swing.controls.GuiCaptionComponent;
import com.sap.sdt.gui.core.swing.controls.GuiRadioButton;
import com.sap.sdt.gui.core.swing.util.SwingToolkit;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

class GuiRadioBox
extends GuiCaptionComponent
implements SDTRadioBoxIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/core/swing/controls/GuiRadioBox.java#2 $";
    private final JPanel panel;
    private JPanel buttonPanel;
    private ButtonGroup buttonGroup;

    GuiRadioBox() {
        super(new JPanel());
        this.panel = (JPanel)this.peer;
        this.buttonPanel = new JPanel();
        this.buttonGroup = new ButtonGroup();
        this.createDefaultLayout();
    }

    public void createDefaultLayout() {
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 1));
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.panel.add(this.caption);
        this.panel.add(this.buttonPanel);
        this.caption.setLabelFor(this.buttonPanel);
        this.panel.putClientProperty("alignable_container", Boolean.TRUE);
        this.panel.putClientProperty("left_component", this.caption);
        this.panel.putClientProperty("right_component", this.buttonPanel);
        this.caption.putClientProperty("alignment", "top");
    }

    public void setCaption(String text, char mnemonic) {
        this.caption.setText(SwingToolkit.getPlainText(text));
        this.caption.setMaximumSize(this.caption.getPreferredSize());
    }

    public void setMnemonicIndex(int index) {
    }

    public void setEnabled(boolean isEnabled) {
        this.panel.setEnabled(isEnabled);
        this.buttonPanel.setEnabled(isEnabled);
        Enumeration<AbstractButton> it = this.buttonGroup.getElements();
        while (it.hasMoreElements()) {
            JRadioButton rB = (JRadioButton)it.nextElement();
            rB.setEnabled(isEnabled);
        }
    }

    public boolean validate() {
        return true;
    }

    public void add(SDTRadioButtonIF radioButton) {
        JRadioButton rb = ((GuiRadioButton)radioButton).getButton();
        this.buttonGroup.add(rb);
        this.buttonPanel.add(rb);
    }
}

