/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.controls;

import com.sap.sdt.engine.core.controls.SDTProgressPanelIF;
import com.sap.sdt.gui.core.images.ImageHolder;
import com.sap.sdt.gui.core.settings.GuiSettings;
import com.sap.sdt.gui.core.swing.controls.GuiComponent;
import com.sap.sdt.gui.core.swing.controls.GuiStyledText;
import com.sap.sdt.gui.core.swing.util.SwingToolkit;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;

public class GuiProgressPanel
extends GuiComponent
implements SDTProgressPanelIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/core/swing/controls/GuiProgressPanel.java#3 $";
    private boolean syncProgressWithList = true;
    private final JPanel panel = (JPanel)this.peer;
    private final JLabel lbRemaining = new JLabel();
    private final JProgressBar pbTotal = new JProgressBar();
    private final JList lsComponents = new JReadOnlyList();
    private final GuiStyledText stText = new GuiStyledText();
    private final JLabel lbImage = new JLabel();
    private static JFrame frameMain;

    public GuiProgressPanel() {
        super(new JPanel());
        this.createDefaultLayout();
    }

    public void createDefaultLayout() {
        this.panel.setLayout(new BorderLayout(10, 10));
        this.panel.putClientProperty("scrollable_form", Boolean.TRUE);
        this.panel.putClientProperty("resizing", Boolean.TRUE);
        JPanel pnUpper = new JPanel();
        pnUpper.setLayout(new BoxLayout(pnUpper, 1));
        this.lbRemaining.setHorizontalAlignment(2);
        this.lbRemaining.setAlignmentX(0.0f);
        this.lbRemaining.setFont(GuiSettings.getInstance().getFont("label"));
        this.lbRemaining.setText("Phase");
        this.pbTotal.setAlignmentX(0.0f);
        this.pbTotal.setFont(GuiSettings.getInstance().getFont("label"));
        pnUpper.add(this.lbRemaining);
        pnUpper.add(Box.createVerticalStrut(5));
        pnUpper.add(this.pbTotal);
        this.panel.add((Component)pnUpper, "North");
        this.lsComponents.setFocusable(false);
        this.lsComponents.setOpaque(true);
        this.lsComponents.setBackground(new Color(this.panel.getBackground().getRGB()));
        this.lsComponents.setFont(GuiSettings.getInstance().getFont("label"));
        this.lsComponents.setSelectionMode(0);
        this.lsComponents.setForeground(Color.black);
        this.lsComponents.setCellRenderer(new CheckCellRenderer());
        JScrollPane sc = new JScrollPane(this.lsComponents);
        sc.setAlignmentX(0.5f);
        JPanel pnComponents = new JPanel();
        pnComponents.setLayout(new BorderLayout(0, 5));
        JLabel lbComponents = new JLabel();
        lbComponents.setHorizontalAlignment(2);
        lbComponents.setFont(GuiSettings.getInstance().getFont("label"));
        lbComponents.setText("Phase");
        pnComponents.add((Component)lbComponents, "North");
        pnComponents.add((Component)sc, "Center");
        this.panel.add((Component)pnComponents, "Center");
        JPanel pnInner = new JPanel();
        pnInner.setLayout(new BoxLayout(pnInner, 1));
        JComponent tx = this.stText.getPeer();
        tx.setAlignmentX(0.0f);
        SwingToolkit.setHeight(tx, 54);
        this.lbImage.setHorizontalAlignment(2);
        this.lbImage.setVerticalAlignment(1);
        this.lbImage.setAlignmentX(0.0f);
        SwingToolkit.setWidth(this.lbImage, 500);
        SwingToolkit.setHeight(this.lbImage, 320);
        pnInner.add(tx);
        pnInner.add(Box.createVerticalStrut(5));
        pnInner.add(this.lbImage);
        pnInner.add(Box.createVerticalGlue());
        this.panel.add((Component)pnInner, "East");
    }

    public void refresh() {
    }

    public void setEnabled(boolean isEnabled) {
    }

    public boolean validate() {
        return true;
    }

    public void setMinimum(int value) {
        this.syncProgressWithList = false;
        this.setMinimumProgress(value);
    }

    public void setMaximum(int value) {
        this.syncProgressWithList = false;
        this.setMaximumProgress(value);
    }

    public void setCurrent(int value) {
        this.syncProgressWithList = false;
        this.setCurrentProgress(value);
    }

    public void setProgressList(String[] items) {
        this.lsComponents.setListData(items);
        this.lsComponents.clearSelection();
        if (this.syncProgressWithList) {
            this.setMaximumProgress(items.length);
            this.setMinimumProgress(0);
        }
    }

    public void setProgressListIndex(int index) {
        int indexHigh = this.lsComponents.getModel().getSize() - 1;
        if (index < 0 || index > indexHigh) {
            this.lsComponents.clearSelection();
        } else {
            this.lsComponents.setSelectedIndex(index);
            this.lsComponents.ensureIndexIsVisible(index);
        }
        if (this.syncProgressWithList) {
            if (index == -1) {
                this.setCurrentProgress(-1);
            } else {
                this.setCurrentProgress(index);
            }
        }
        this.lbRemaining.setText("Phase " + (index + 1) + " of " + this.lsComponents.getModel().getSize());
    }

    public void setText(String text) {
        this.stText.setText(text);
    }

    public void setImage(byte[] imageData) {
        if (imageData == null || imageData.length == 0) {
            return;
        }
        this.lbImage.setIcon(new ImageIcon(imageData));
    }

    private void setMinimumProgress(int value) {
        this.pbTotal.setMinimum(value);
    }

    private void setMaximumProgress(int value) {
        this.pbTotal.setMaximum(value + 1);
    }

    private void setCurrentProgress(int value) {
        this.pbTotal.setValue(++value);
    }

    private static GuiProgressPanel createTestPanel() {
        GuiProgressPanel progress = new GuiProgressPanel();
        Vector<String> data = new Vector<String>();
        data.add("Line1");
        data.add("Line2");
        data.add("Line3 is a very long line to test the horizontal scrollbar");
        data.add("Line4");
        data.add("Line5");
        data.add("Line6");
        data.add("Line7");
        data.add("Line8");
        data.add("Line9");
        progress.setProgressList(data.toArray(new String[data.size()]));
        return progress;
    }

    public static void test() {
        JFrame f;
        frameMain = f = new JFrame("GuiProgressPanel Test");
        GuiProgressPanel progress = GuiProgressPanel.createTestPanel();
        f.setContentPane(progress.getPeer());
        f.pack();
        f.setLocation(200, 100);
        f.show();
        progress.setProgressListIndex(1);
        progress.setMinimum(0);
        progress.setMaximum(50);
        progress.setCurrent(25);
    }

    public static void main(String[] args) {
        GuiSettings.getInstance();
        GuiProgressPanel.test();
        frameMain.setDefaultCloseOperation(3);
    }

    public static void print(Component comp) {
        if (comp == null) {
            System.out.println("component = null");
            return;
        }
        System.out.println("class name=" + comp.getClass().getName());
        System.out.println("min size : width=" + comp.getMinimumSize().width + "   height=" + comp.getMinimumSize().height);
        System.out.println("pref size: width=" + comp.getPreferredSize().width + "   height=" + comp.getPreferredSize().height);
        System.out.println("max size : width=" + comp.getMaximumSize().width + "   height=" + comp.getMaximumSize().height);
        System.out.println("real size : width=" + comp.getSize().width + "   height=" + comp.getSize().height);
    }

    private static class CheckCellRenderer
    extends DefaultListCellRenderer {
        private CheckCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setIcon(index < list.getSelectedIndex() ? ImageHolder.CHECK_ICON : ImageHolder.DUMMY_ICON);
            return this;
        }
    }

    private static class JReadOnlyList
    extends JList {
        private JReadOnlyList() {
        }

        public void addMouseListener(MouseListener l) {
        }

        public void addMouseMotionListener(MouseMotionListener l) {
        }

        protected void processKeyEvent(KeyEvent e) {
        }
    }
}

