/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.controls;

import com.sap.sdt.engine.core.controls.SDTComponentIF;
import com.sap.sdt.engine.core.controls.SDTGuiIF;
import com.sap.sdt.engine.core.controls.SDTMenuIF;
import com.sap.sdt.engine.core.controls.SDTMessageBoxIF;
import com.sap.sdt.engine.core.controls.SDTPerspectiveIF;
import com.sap.sdt.engine.core.controls.SDTViewIF;
import com.sap.sdt.engine.core.controls.mgmt.SDTPerspectiveManager;
import com.sap.sdt.gui.core.swing.controls.GuiContainer;
import com.sap.sdt.gui.core.swing.controls.GuiMessageBox;
import com.sap.sdt.gui.core.swing.ui.Gui;
import com.sap.sdt.gui.core.swing.util.SwingToolkit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class GuiPerspective
extends GuiContainer
implements SDTPerspectiveIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/core/swing/controls/GuiPerspective.java#2 $";
    protected SDTGuiIF parent = null;
    private SDTPerspectiveManager manager = null;
    private JDialog msgDialog = null;

    public GuiPerspective() {
        this.peer().setLayout(new BorderLayout());
    }

    public void setParent(SDTGuiIF parent) {
        this.parent = parent;
    }

    public SDTGuiIF getParent() {
        return this.parent;
    }

    public void addView(SDTViewIF view) {
        this.getPerspectiveManager().registerView(view);
        this.add(view);
        view.setParent(this);
    }

    public void addMenu(SDTViewIF view, SDTComponentIF menu) {
        this.getPerspectiveManager().addViewMenu(view, menu);
    }

    public void setGuiTitle(SDTViewIF view, String title) {
        this.getPerspectiveManager().setGuiTitle(view, title);
    }

    public void setStatus(SDTViewIF view, String status) {
        this.getPerspectiveManager().setViewStatus(view, status);
    }

    public void setStatus(String status) {
        if (this.parent != null) {
            this.parent.setStatus(status);
        }
    }

    public SDTPerspectiveManager getPerspectiveManager() {
        if (this.manager == null) {
            this.manager = new SDTPerspectiveManager(this);
        }
        return this.manager;
    }

    public void addMenu(SDTMenuIF menu) {
        this.getPerspectiveManager().addMenu(menu);
    }

    public List getMenus() {
        return this.getPerspectiveManager().getMenus();
    }

    public void hidePopup(SDTViewIF view) {
        SDTPerspectiveManager pM = this.getPerspectiveManager();
        pM.popPopup(view);
        if (pM.isActive(view)) {
            this.msgDialog.setVisible(false);
        }
    }

    public void showPopup(SDTViewIF view, SDTMessageBoxIF popup) {
        SDTPerspectiveManager pM = this.getPerspectiveManager();
        pM.pushPopup(view, popup);
        if (pM.isActive(view)) {
            if (this.msgDialog != null) {
                this.msgDialog.setVisible(false);
                this.msgDialog = null;
            }
            JFrame frame = ((Gui)this.getParent()).getPeer();
            this.msgDialog = new JDialog(frame, popup.getTitle(), popup.isModal());
            ((GuiMessageBox)popup).setWindow(this.msgDialog);
            this.msgDialog.setDefaultCloseOperation(0);
            JPanel pnContent = (JPanel)((GuiMessageBox)popup).getPeer();
            this.msgDialog.setContentPane(pnContent);
            this.msgDialog.pack();
            SwingToolkit.setLocationRelativeTo(this.msgDialog, frame);
            if (pnContent == null) {
                return;
            }
            this.msgDialog.setVisible(true);
            KeyboardFocusManager kbdFocusMngr = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            FocusTraversalPolicy focusTraversalPolicy = kbdFocusMngr.getDefaultFocusTraversalPolicy();
            Component compFocus = focusTraversalPolicy.getDefaultComponent(pnContent);
            if (compFocus != null) {
                // empty if block
            }
        }
    }

    public void activate() {
        SDTPerspectiveManager pM = this.getPerspectiveManager();
        pM.activate(this);
    }

    public void deactivate() {
        SDTPerspectiveManager pM = this.getPerspectiveManager();
        pM.deactivate(this);
    }
}

