/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.controls;

import com.sap.sdt.engine.core.controls.SDTPasswordFieldIF;
import com.sap.sdt.gui.core.resources.ResourceManager;
import com.sap.sdt.gui.core.settings.GuiSettings;
import com.sap.sdt.gui.core.swing.controls.GuiCaptionComponent;
import com.sap.sdt.gui.core.swing.util.JSecurePasswordField;
import com.sap.sdt.gui.core.swing.util.SelectAllFocusListener;
import com.sap.sdt.gui.core.swing.util.SwingToolkit;
import com.sap.sdt.gui.core.swing.util.ValidateDocument;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

class GuiPasswordField
extends GuiCaptionComponent
implements SDTPasswordFieldIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/core/swing/controls/GuiPasswordField.java#2 $";
    private JSecurePasswordField pwdField;
    private JSecurePasswordField confirm_pwdField;
    private JPanel valueComponent;
    private boolean isConfirm;
    private int maxLength;
    private int minLength;
    private final JPanel panel;
    private JLabel confirm_caption;
    private Component hStrutLeft;
    private Component hStrutRight;

    GuiPasswordField() {
        super(new JPanel());
        this.panel = (JPanel)this.peer;
        this.confirm_caption = new JLabel();
        this.pwdField = new JSecurePasswordField();
        this.confirm_pwdField = new JSecurePasswordField();
        this.createDefaultLayout();
    }

    public boolean validate() {
        this.removeInvalidFlag();
        boolean isValid = true;
        this.setAdditionalHelpText("");
        int length = this.getLength();
        if (this.minLength != 0 && length < this.minLength) {
            isValid = false;
            this.setAdditionalHelpText(this.getAdditionalHelpText() + "Password field '" + this.caption.getText() + "' must be at least " + this.minLength + " characters long.<p>");
        }
        if (this.maxLength != 0 && length > this.maxLength) {
            isValid = false;
            this.setAdditionalHelpText(this.getAdditionalHelpText() + "Password field '" + this.caption.getText() + "' must be at most " + this.maxLength + " characters long.<p>");
        }
        if (this.isConfirm && !Arrays.equals(this.getText(), this.getConfirmText())) {
            isValid = false;
            this.setAdditionalHelpText(this.getAdditionalHelpText() + "Passwords for field '" + this.caption.getText() + "' must match.<p>");
        }
        if (!isValid) {
            this.flagInvalidEntry();
            this.setAdditionalHelpText("<html><br><strong>Field Limitations</strong><p>" + this.getAdditionalHelpText());
        }
        return isValid;
    }

    public void setText(String text) {
        this.pwdField.setText(text);
        this.confirm_pwdField.setText(text);
    }

    public char[] getText() {
        char[] pwd = this.pwdField.getPassword();
        return pwd;
    }

    public void setConfirm(boolean isConfirm) {
        this.isConfirm = isConfirm;
        this.hStrutLeft.setVisible(isConfirm);
        this.hStrutRight.setVisible(isConfirm);
        this.confirm_pwdField.setVisible(isConfirm);
        this.confirm_caption.setVisible(isConfirm);
    }

    public char[] getConfirmText() {
        char[] pwd = this.confirm_pwdField.getPassword();
        return pwd;
    }

    public void setEnabled(boolean enabled) {
        this.pwdField.setEnabled(enabled);
        this.caption.setEnabled(enabled);
        if (this.isConfirm) {
            this.confirm_pwdField.setEnabled(enabled);
            this.confirm_caption.setEnabled(enabled);
        }
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
        if (maxLength != 0) {
            ((ValidateDocument)this.pwdField.getDocument()).setMaxLength(maxLength);
            this.pwdField.setColumns(maxLength);
            if (this.isConfirm) {
                ((ValidateDocument)this.confirm_pwdField.getDocument()).setMaxLength(maxLength);
                this.confirm_pwdField.setColumns(maxLength);
            }
            Dimension dim = this.pwdField.getPreferredSize();
            JPanel pn = (JPanel)this.panel.getClientProperty("right_component");
            SwingToolkit.setWidth(this.pwdField, dim.width + 1);
            SwingToolkit.setWidth(this.confirm_pwdField, dim.width + 1);
        }
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    private void createDefaultLayout() {
        this.pwdField.setDocument(new ValidateDocument());
        this.confirm_pwdField.setDocument(new ValidateDocument());
        JPanel left_panel = new JPanel();
        left_panel.setLayout(new BoxLayout(left_panel, 1));
        this.confirm_caption.setText(ResourceManager.getString("password.confirm.text"));
        this.confirm_caption.setHorizontalAlignment(2);
        int vertSpace = GuiSettings.getInstance().getInt("layout.vertical.gap");
        this.hStrutLeft = Box.createVerticalStrut(vertSpace);
        this.hStrutRight = Box.createVerticalStrut(vertSpace);
        left_panel.add(this.caption);
        left_panel.add(this.hStrutLeft);
        left_panel.add(this.confirm_caption);
        JPanel right_panel = new JPanel();
        right_panel.setLayout(new BoxLayout(right_panel, 1));
        this.pwdField.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.pwdField.getPreferredSize().height));
        this.confirm_pwdField.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.confirm_pwdField.getPreferredSize().height));
        this.pwdField.setAlignmentX(0.0f);
        this.confirm_pwdField.setAlignmentX(0.0f);
        right_panel.add(this.pwdField);
        right_panel.add(this.hStrutRight);
        right_panel.add(this.confirm_pwdField);
        this.panel.setLayout(new BoxLayout(this.panel, 0));
        this.panel.add(left_panel);
        this.panel.add(Box.createHorizontalStrut(GuiSettings.getInstance().getInt("layout.horizontal.gap")));
        this.panel.add(right_panel);
        this.panel.putClientProperty("alignable_container", Boolean.TRUE);
        this.panel.putClientProperty("left_component", left_panel);
        this.panel.putClientProperty("right_component", right_panel);
        this.pwdField.addKeyListener(this.keyL);
        this.confirm_pwdField.addKeyListener(this.keyL);
        this.confirm_caption.setFont(GuiSettings.getInstance().getFont("label"));
        this.pwdField.setFont(GuiSettings.getInstance().getFont("input"));
        this.confirm_pwdField.setFont(GuiSettings.getInstance().getFont("input"));
        this.caption.setLabelFor(this.pwdField);
        this.confirm_caption.setLabelFor(this.confirm_pwdField);
        SelectAllFocusListener.register(this.pwdField);
        SelectAllFocusListener.register(this.confirm_pwdField);
    }

    private int getLength() {
        char[] pwd = this.pwdField.getPassword();
        int length = pwd.length;
        Arrays.fill(pwd, 'X');
        return length;
    }

    private void flagInvalidEntry() {
        SwingToolkit.setHighlightBorder(this.pwdField);
        if (this.isConfirm) {
            SwingToolkit.setHighlightBorder(this.confirm_pwdField);
        }
    }

    private void removeInvalidFlag() {
        SwingToolkit.removeHighlightBorder(this.pwdField);
        if (this.isConfirm) {
            SwingToolkit.removeHighlightBorder(this.confirm_pwdField);
        }
    }
}

