/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.controls;

import com.sap.sdt.engine.core.controls.SDTPanelIF;
import com.sap.sdt.gui.core.settings.GuiSettings;
import com.sap.sdt.gui.core.swing.controls.AlignableLayout;
import com.sap.sdt.gui.core.swing.controls.GuiContainer;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class GuiPanel
extends GuiContainer
implements SDTPanelIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/core/swing/controls/GuiPanel.java#2 $";

    public void setLayout(int layout) {
        int hgap = GuiSettings.getInstance().getInt("layout.horizontal.gap");
        int vgap = GuiSettings.getInstance().getInt("layout.vertical.gap");
        switch (layout) {
            case 0: {
                this.peer().setLayout(new AlignableLayout(hgap, vgap));
                this.peer().putClientProperty("resizing", Boolean.TRUE);
                break;
            }
            case 1: {
                this.peer().setLayout(new GridLayout(1, 0, hgap, vgap));
                break;
            }
            case 3: {
                this.peer().setLayout(new GridLayout(1, 0, hgap, vgap));
                break;
            }
        }
    }

    public void setBorder(int border) {
        switch (border) {
            case 0: {
                this.peer().setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                break;
            }
            case 1: {
                this.peer().setBorder(BorderFactory.createEtchedBorder());
                break;
            }
        }
    }

    public void setBorderTitle(String borderTitle) {
        Border etchedB = BorderFactory.createEtchedBorder();
        TitledBorder titledB = BorderFactory.createTitledBorder(etchedB, borderTitle);
        this.peer().setBorder(titledB);
    }
}

