/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.controls;

import com.sap.sdt.engine.core.controls.SDTActionListenerIF;
import com.sap.sdt.engine.core.controls.SDTTableIF;
import com.sap.sdt.engine.core.controls.table.SDTTableColumn;
import com.sap.sdt.engine.core.controls.table.SDTTableRow;
import com.sap.sdt.gui.core.swing.controls.GuiComponent;
import com.sap.sdt.gui.core.swing.controls.GuiTableModel;
import com.sap.sdt.gui.core.swing.controls.table.GuiTableEditor;
import com.sap.sdt.gui.core.swing.controls.table.editors.IntegerCellEditor;
import com.sap.sdt.gui.core.swing.controls.table.editors.TextCellEditor;
import com.sap.sdt.gui.core.swing.controls.table.renderers.CheckBoxCellRenderer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class GuiOutlineTable
extends GuiComponent
implements SDTTableIF,
ListSelectionListener,
FocusListener {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/core/swing/controls/GuiOutlineTable.java#2 $";
    private GuiTableModel model;
    private final JPanel panel;
    private JTable table;
    private GuiTableEditor modifier;

    GuiOutlineTable() {
        super(new JPanel());
        this.panel = (JPanel)this.peer;
        this.panel.setLayout(new GridBagLayout());
        this.model = new GuiTableModel();
        this.table = new JTable(this.model);
        this.table.setFocusTraversalKeys(0, null);
        this.table.setFocusTraversalKeys(1, null);
        ListSelectionModel rowSM = this.table.getSelectionModel();
        rowSM.addListSelectionListener(this);
        JScrollPane scroll = new JScrollPane(this.table);
        this.modifier = new GuiTableEditor(this);
        this.panel.add((Component)scroll, new GridBagConstraints(0, 0, 3, 1, 0.1, 0.1, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.panel.add((Component)this.modifier, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.table.addFocusListener(this);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            public void columnAdded(TableColumnModelEvent e) {
            }

            public void columnMoved(TableColumnModelEvent e) {
            }

            public void columnRemoved(TableColumnModelEvent e) {
            }

            public void columnMarginChanged(ChangeEvent e) {
            }

            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
    }

    public boolean validate() {
        return true;
    }

    public void addColumn(SDTTableColumn column) {
        this.model.getColumnNames().add(column.getCaption());
        this.model.setEditable(false);
        TableColumn c = new TableColumn(this.model.getColumnCount() - 1);
        c.setHeaderValue(this.model.getColumnName(this.model.getColumnCount() - 1));
        int type = column.getColumnType();
        TableCellRenderer renderer = null;
        switch (type) {
            case 0: {
                renderer = new DefaultTableCellRenderer();
                break;
            }
            case 1: {
                renderer = new CheckBoxCellRenderer();
                break;
            }
            case 2: {
                renderer = new DefaultTableCellRenderer();
                break;
            }
        }
        c.setCellRenderer(renderer);
        TableColumnModel columns = this.table.getColumnModel();
        columns.addColumn(c);
        c.sizeWidthToFit();
        this.modifier.addElement(column);
        this.initColumnSizes(c, this.model.getColumnCount() - 1);
    }

    public SDTTableColumn getColumn(int index) {
        SDTTableColumn column = new SDTTableColumn();
        List values = this.model.getColumnValues(index);
        int n = values.size();
        for (int i = 0; i < n; ++i) {
            column.addValue(values.get(i));
        }
        return column;
    }

    public SDTTableColumn[] getColumns() {
        SDTTableColumn[] columns = new SDTTableColumn[this.model.getColumnCount()];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = this.getColumn(i);
        }
        return columns;
    }

    public void removeRow(int index) {
        this.model.removeRow(index);
    }

    public void setEnabled(boolean enabled) {
        this.model.setEditable(enabled);
    }

    public void addRow(List data) {
        this.model.addRow(data);
    }

    public SDTTableRow getRow(int row) {
        return null;
    }

    private TableCellEditor getTextCellEditor(SDTTableColumn column) {
        int constarints = column.getConstraints();
        if (column.getConstraint(1)) {
            int minValue = column.getConstraintValue(2);
            int maxValue = column.getConstraintValue(3);
            return new IntegerCellEditor(minValue, maxValue);
        }
        int minLength = column.getConstraintValue(0);
        int maxLength = column.getConstraintValue(1);
        boolean upper = column.getConstraint(2);
        TextCellEditor editor = new TextCellEditor();
        editor.setMaxLength(maxLength);
        editor.setUpper(upper);
        return editor;
    }

    public void enableAddRemove(boolean areRowsFixed) {
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e == null || e.getValueIsAdjusting()) {
            return;
        }
        int[] rows = this.table.getSelectedRows();
        if (rows.length < 0) {
            return;
        }
        if (rows.length == 1) {
            // empty if block
        }
    }

    public int[] getSelectedRows() {
        return this.table.getSelectedRows();
    }

    public void focusGained(FocusEvent e) {
        int[] rows = this.table.getSelectedRows();
        if (rows.length == 0 && this.table.getRowCount() > 0) {
            this.table.setRowSelectionInterval(0, 0);
            this.table.setColumnSelectionInterval(0, this.table.getColumnCount() - 1);
        }
    }

    public void focusLost(FocusEvent e) {
    }

    private void initColumnSizes(TableColumn column, int pos) {
        TableColumnModel columnModel = this.table.getColumnModel();
        TableColumn colum1n = columnModel.getColumn(0);
        column.setWidth(10);
    }

    public void modify(Object value, int row, int column) {
        this.table.getModel().setValueAt(value, row, column);
    }

    public JTable getTable() {
        return this.table;
    }

    public void addRow(SDTTableRow row) {
    }

    public int getRowCount() {
        return 0;
    }

    public void setCaption(String caption, char mnemonic) {
    }

    public void addBrowseListener(String action, SDTActionListenerIF listener) {
    }

    public Object getEditingCellValue() {
        return null;
    }

    public void setEditingCellValue(Object value) {
    }

    public SDTTableColumn getEditingColumn() {
        return null;
    }
}

