/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.core.swing.controls;

import com.sap.sdt.engine.core.controls.SDTButtonIF;
import com.sap.sdt.engine.core.controls.SDTMessageBoxIF;
import com.sap.sdt.gui.core.settings.GuiSettings;
import com.sap.sdt.gui.core.swing.controls.GuiButton;
import com.sap.sdt.gui.core.swing.controls.GuiComponent;
import com.sap.sdt.gui.core.swing.controls.GuiScrollableStyledText;
import com.sap.sdt.gui.core.swing.controls.text.GuiHTMLEditorKit;
import com.sap.sdt.gui.core.swing.util.SwingToolkit;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.text.html.HTMLEditorKit;

public class GuiMessageBox
extends GuiComponent
implements SDTMessageBoxIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/core/swing/controls/GuiMessageBox.java#2 $";
    private static final GuiSettings settings = GuiSettings.getInstance();
    private static final int buttonSpace = settings.getInt("netweaver.button.space.side");
    private final JPanel pn = (JPanel)this.peer;
    private GuiScrollableStyledText tx;
    private JPanel pnNavigation;
    private JButton bnDefault;
    private int maxWidth = 0;
    private Window window;
    private String title;
    private boolean modal;
    private static final HTMLEditorKit htmlKit = new GuiHTMLEditorKit();
    private static JFrame m_fMain;

    GuiMessageBox() {
        super(new JPanel());
        this.createDefaultLayout();
    }

    private void createDefaultLayout() {
        this.pn.setLayout(new BorderLayout());
        this.pn.setBackground(Color.white);
        this.pn.setBorder(BorderFactory.createEmptyBorder(settings.getInt("netweaver.content.space.top"), settings.getInt("netweaver.content.space.side"), settings.getInt("netweaver.content.space.bottom"), settings.getInt("netweaver.content.space.side")));
        this.tx = new GuiScrollableStyledText();
        this.tx.setSelectable(false);
        this.pn.add((Component)this.tx.getPeer(), "Center");
        this.pnNavigation = new JPanel();
        this.pnNavigation.setLayout(new BoxLayout(this.pnNavigation, 0));
        this.pnNavigation.setBackground(Color.white);
        this.pnNavigation.setBorder(BorderFactory.createEmptyBorder(settings.getInt("netweaver.form.navigation.gap"), 0, 0, 0));
        this.pnNavigation.add(Box.createHorizontalGlue());
        JButton bn = new JButton("OK");
        this.pnNavigation.add(bn);
        SwingToolkit.fixHeight(this.pnNavigation);
        this.pnNavigation.remove(bn);
        this.pn.add((Component)this.pnNavigation, "South");
    }

    public void setWindow(Window window) {
        this.window = window;
        if (this.bnDefault != null) {
            JRootPane rootPane = ((RootPaneContainer)((Object)window)).getRootPane();
            rootPane.setDefaultButton(this.bnDefault);
        }
    }

    public void setMessageText(String text) {
        this.tx.setText(text);
    }

    public void addButton(SDTButtonIF button) {
        JButton bn = (JButton)((GuiButton)button).getPeer();
        int width = bn.getPreferredSize().width + buttonSpace * 2;
        if (width > this.maxWidth) {
            this.maxWidth = width;
            int n = this.pnNavigation.getComponentCount();
            for (int i = 0; i < n; ++i) {
                JComponent comp = (JComponent)this.pnNavigation.getComponent(i);
                if (!(comp instanceof JButton)) continue;
                comp.setPreferredSize(new Dimension(this.maxWidth, comp.getPreferredSize().height));
            }
        }
        bn.setPreferredSize(new Dimension(this.maxWidth, bn.getPreferredSize().height));
        this.pnNavigation.add(Box.createHorizontalStrut(settings.getInt("netweaver.button.gap")));
        this.pnNavigation.add(bn);
        if (button.isDefault()) {
            this.bnDefault = bn;
        }
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isModal() {
        return this.modal;
    }

    public void setModal(boolean modal) {
        this.modal = modal;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setEnabled(boolean isEnabled) {
    }

    public boolean validate() {
        return true;
    }

    public static void test() {
        JFrame f = new JFrame("MessageBox Test");
        GuiMessageBox box = new GuiMessageBox();
        box.setMessageText("An error is occured that caused the installation to abort.");
        GuiButton bnOK = new GuiButton();
        bnOK.setCaption("OK", 'o');
        bnOK.setDefault(false);
        box.addButton(bnOK);
        GuiButton bnCancel = new GuiButton();
        bnCancel.setCaption("Cancel", 'c');
        bnCancel.setDefault(true);
        box.addButton(bnCancel);
        f.setContentPane(box.getPeer());
        box.setWindow(f);
        f.pack();
        f.setLocation(100, 100);
        f.setSize(500, 200);
        f.show();
        m_fMain = f;
    }

    public static void main(String[] args) {
        GuiSettings.getInstance();
        GuiMessageBox.test();
        m_fMain.setDefaultCloseOperation(3);
    }
}

